/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.administrative.FlowCurationUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.Choices;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowItemUtils {
    private static final Message T_metadata_updated = new Message("default", "The Item's metadata was successfully updated.");
    private static final Message T_metadata_added = new Message("default", "New metadata was added.");
    private static final Message T_item_withdrawn = new Message("default", "The item has been withdrawn.");
    private static final Message T_item_public = new Message("default", "The item is now public.");
    private static final Message T_item_private = new Message("default", "The item is now private.");
    private static final Message T_item_reinstated = new Message("default", "The item has been reinstated.");
    private static final Message T_item_moved = new Message("default", "The item has been moved.");
    private static final Message T_item_move_destination_not_found = new Message("default", "The selected destination collection could not be found.");
    private static final Message T_bitstream_added = new Message("default", "The new bitstream was successfully uploaded.");
    private static final Message T_bitstream_failed = new Message("default", "Error while uploading file.");
    private static final Message T_bitstream_updated = new Message("default", "The bitstream has been updated.");
    private static final Message T_bitstream_delete = new Message("default", "The selected bitstreams have been deleted.");
    private static final Message T_bitstream_order = new Message("default", "The bitstream order has been successfully altered.");
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected static final BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public static FlowResult resolveItemIdentifier(Context context, String identifier) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        if (identifier.contains("/")) {
            DSpaceObject dso = handleService.resolveToObject(context, identifier);
            if (dso != null && dso.getType() == 2) {
                result.setParameter("itemID", (Object)dso.getID());
                result.setParameter("type", (Object)2);
                result.setContinue(true);
                return result;
            }
        } else {
            Item item = null;
            try {
                item = (Item)itemService.find(context, UUID.fromString(identifier));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (item != null) {
                result.setParameter("itemID", (Object)item.getID());
                result.setParameter("type", (Object)2);
                result.setContinue(true);
                return result;
            }
        }
        result.addError("identifier");
        return result;
    }

    public static FlowResult processEditItem(Context context, UUID itemID, Request request) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        String scope = request.getParameter("scope");
        if ("*".equals(scope)) {
            itemService.clearMetadata(context, (DSpaceObject)item, "*", "*", "*", "*");
        } else {
            String[] parts = FlowItemUtils.parseName((String)scope);
            itemService.clearMetadata(context, (DSpaceObject)item, parts[0], parts[1], parts[2], "*");
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameterName = (String)parameters.nextElement();
            if (!parameterName.startsWith("name_")) continue;
            String parameterValue = request.getParameter(parameterName);
            if (!"*".equals(scope) && !scope.equals(parameterValue)) continue;
            String indexString = parameterName.substring("name_".length());
            Integer index = Integer.valueOf(indexString);
            indexes.add(index);
        }
        Integer index = 1;
        while (index <= indexes.size()) {
            String name = request.getParameter("name_" + index);
            String value = request.getParameter("value_" + index);
            String authority = request.getParameter("value_" + index + "_authority");
            String confidence = request.getParameter("value_" + index + "_confidence");
            String lang = request.getParameter("language_" + index);
            String remove = request.getParameter("remove_" + index);
            if (StringUtils.isBlank((String)lang)) {
                lang = null;
            }
            if (remove == null) {
                String[] parts = FlowItemUtils.parseName((String)name);
                int iconf = -1;
                if (confidence != null && confidence.length() > 0) {
                    iconf = Choices.getConfidenceValue((String)confidence);
                }
                if (authority != null && authority.length() > 0 && iconf == -1) {
                    iconf = 0;
                }
                itemService.addMetadata(context, (DSpaceObject)item, parts[0], parts[1], parts[2], lang, value, authority, iconf);
            }
            index = index + 1;
        }
        itemService.update(context, (DSpaceObject)item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_metadata_updated);
        return result;
    }

    public static FlowResult processAddMetadata(Context context, UUID itemID, Request request) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        String fieldID = request.getParameter("field");
        String value = request.getParameter("value");
        String language = request.getParameter("language");
        MetadataField field = metadataFieldService.find(context, Integer.valueOf(fieldID).intValue());
        itemService.addMetadata(context, (DSpaceObject)item, field.getMetadataSchema().getName(), field.getElement(), field.getQualifier(), language, value);
        itemService.update(context, (DSpaceObject)item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_metadata_added);
        return result;
    }

    public static FlowResult processWithdrawItem(Context context, UUID itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        itemService.withdraw(context, item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_withdrawn);
        return result;
    }

    public static FlowResult processReinstateItem(Context context, UUID itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        itemService.reinstate(context, item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_reinstated);
        return result;
    }

    public static FlowResult processPrivateItem(Context context, UUID itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        item.setDiscoverable(false);
        itemService.update(context, (DSpaceObject)item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_private);
        return result;
    }

    public static FlowResult processPublicItem(Context context, UUID itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        item.setDiscoverable(true);
        itemService.update(context, (DSpaceObject)item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_public);
        return result;
    }

    public static FlowResult processMoveItem(Context context, UUID itemID, UUID collectionID, boolean inherit) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        if (authorizeService.isAdmin(context, (DSpaceObject)item)) {
            Collection destination;
            if (itemService.canEdit(context, item)) {
                authorizeService.authorizeAction(context, (DSpaceObject)item, 1);
            }
            if ((destination = (Collection)collectionService.find(context, collectionID)) == null) {
                result.setOutcome(false);
                result.setContinue(false);
                result.setMessage(T_item_move_destination_not_found);
                return result;
            }
            Collection owningCollection = item.getOwningCollection();
            if (destination.equals((Object)owningCollection)) {
                result.setOutcome(false);
                result.setContinue(false);
                return result;
            }
            boolean alreadyInCollection = false;
            for (Collection collection : item.getCollections()) {
                if (!collection.equals((Object)destination)) continue;
                alreadyInCollection = true;
                break;
            }
            if (!alreadyInCollection) {
                collectionService.addItem(context, destination, item);
            }
            if (owningCollection != null) {
                collectionService.removeItem(context, owningCollection, item);
            }
            item.setOwningCollection(destination);
            if (inherit) {
                itemService.inheritCollectionDefaultPolicies(context, item, destination);
            }
            itemService.update(context, (DSpaceObject)item);
            result.setOutcome(true);
            result.setContinue(true);
            result.setMessage(T_item_moved);
        }
        return result;
    }

    public static FlowResult processDeleteItem(Context context, UUID itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        itemService.delete(context, (DSpaceObject)item);
        result.setContinue(true);
        return result;
    }

    public static FlowResult processAddBitstream(Context context, UUID itemID, Request request) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        Object object = request.get("file");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            Bitstream bitstream;
            InputStream is = filePart.getInputStream();
            String bundleName = request.getParameter("bundle");
            List bundles = itemService.getBundles(item, bundleName);
            if (bundles.size() < 1) {
                bitstream = itemService.createSingleBitstream(context, is, item, bundleName);
                Collection owningCollection = item.getOwningCollection();
                if (owningCollection != null) {
                    Bundle bnd = (Bundle)bitstream.getBundles().get(0);
                    bundleService.inheritCollectionDefaultPolicies(context, bnd, owningCollection);
                }
            } else {
                bitstream = bitstreamService.create(context, (Bundle)bundles.get(0), is);
            }
            String name = filePart.getUploadName();
            while (name.indexOf(47) > -1) {
                name = name.substring(name.indexOf(47) + 1);
            }
            while (name.indexOf(92) > -1) {
                name = name.substring(name.indexOf(92) + 1);
            }
            bitstream.setName(context, name);
            bitstream.setSource(context, filePart.getUploadName());
            bitstream.setDescription(context, request.getParameter("description"));
            BitstreamFormat format = bitstreamFormatService.guessFormat(context, bitstream);
            bitstreamService.setFormat(context, bitstream, format);
            bitstreamService.update(context, (DSpaceObject)bitstream);
            itemService.update(context, (DSpaceObject)item);
            FlowItemUtils.processAccessFields((Context)context, (HttpServletRequest)request, (Collection)item.getOwningCollection(), (Bitstream)bitstream);
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_bitstream_added);
        } else {
            result.setContinue(false);
            result.setOutcome(false);
            result.setMessage(T_bitstream_failed);
        }
        return result;
    }

    private static void processAccessFields(Context context, HttpServletRequest request, Collection collection, Bitstream b) throws SQLException, AuthorizeException {
        Date startDate = null;
        try {
            startDate = DateUtils.parseDate((String)request.getParameter("embargo_until_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        String reason = request.getParameter("reason");
        authorizeService.generateAutomaticPolicies(context, startDate, reason, (DSpaceObject)b, collection);
    }

    public static FlowResult processEditBitstream(Context context, UUID itemID, UUID bitstreamID, String bitstreamName, String primary, String description, int formatID, String userFormat, Request request) throws SQLException, AuthorizeException {
        List bundles;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Bitstream bitstream = (Bitstream)bitstreamService.find(context, bitstreamID);
        BitstreamFormat currentFormat = bitstream.getFormat(context);
        if (description != null) {
            bitstream.setDescription(context, description);
        }
        if (bitstreamName != null) {
            bitstream.setName(context, bitstreamName);
        }
        if ((bundles = bitstream.getBundles()) != null && bundles.size() > 0) {
            Bundle bundle = (Bundle)bundles.get(0);
            if (bundle.getPrimaryBitstream() != null && bundle.getPrimaryBitstream().toString().equals(String.valueOf(bitstreamID))) {
                if ("no".equals(primary)) {
                    bundle.setPrimaryBitstreamID(null);
                    bundleService.update(context, (DSpaceObject)bundle);
                }
            } else if ("yes".equals(primary)) {
                bundle.setPrimaryBitstreamID(bitstream);
                bundleService.update(context, (DSpaceObject)bundle);
            }
        }
        if (formatID > 0) {
            BitstreamFormat newFormat;
            if ((currentFormat == null || currentFormat.getID() != formatID) && (newFormat = (BitstreamFormat)bitstreamFormatService.find(context, formatID)) != null) {
                bitstreamService.setFormat(context, bitstream, newFormat);
            }
        } else if (userFormat != null && userFormat.length() > 0) {
            bitstreamService.setUserFormatDescription(context, bitstream, userFormat);
        }
        bitstreamService.update(context, (DSpaceObject)bitstream);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_bitstream_updated);
        return result;
    }

    public static FlowResult processDeleteBitstreams(Context context, UUID itemID, String[] bitstreamIDs) throws SQLException, AuthorizeException, IOException, UIException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        for (String id : bitstreamIDs) {
            String[] parts = id.split("/");
            if (parts.length != 2) {
                throw new UIException("Unable to parse id into bundle and bitstream id: " + id);
            }
            UUID bundleID = UUID.fromString(parts[0]);
            UUID bitstreamID = UUID.fromString(parts[1]);
            Bundle bundle = (Bundle)bundleService.find(context, bundleID);
            Bitstream bitstream = (Bitstream)bitstreamService.find(context, bitstreamID);
            bundleService.removeBitstream(context, bundle, bitstream);
            if (bundle.getBitstreams().size() != 0) continue;
            itemService.removeBundle(context, item, bundle);
        }
        itemService.update(context, (DSpaceObject)item);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_bitstream_delete);
        return result;
    }

    public static FlowResult processReorderBitstream(Context context, UUID itemID, Request request) throws SQLException, AuthorizeException {
        String submitButton = Util.getSubmitButton((HttpServletRequest)request, (String)"submit_update_order");
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = (Item)itemService.find(context, itemID);
        List bundles = item.getBundles();
        for (Bundle bundle : bundles) {
            List bitstreams = bundle.getBitstreams();
            UUID[] newBitstreamOrder = new UUID[bitstreams.size()];
            if (submitButton.equals("submit_update_order")) {
                for (Bitstream bitstream : bitstreams) {
                    int order = Util.getIntParameter((HttpServletRequest)request, (String)("order_" + bitstream.getID()));
                    newBitstreamOrder[--order] = bitstream.getID();
                }
            } else {
                String inputKey = submitButton.replace("submit_order_", "") + "_value";
                if (inputKey.startsWith(bundle.getID() + "_")) {
                    String[] vals = request.getParameter(inputKey).split(",");
                    for (int i = 0; i < vals.length; ++i) {
                        String val = vals[i];
                        newBitstreamOrder[i] = UUID.fromString(val);
                    }
                } else {
                    newBitstreamOrder = null;
                }
            }
            if (newBitstreamOrder == null) continue;
            bundleService.setOrder(context, bundle, newBitstreamOrder);
            bundleService.update(context, (DSpaceObject)bundle);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_bitstream_order);
        return result;
    }

    public static FlowResult processCurateItem(Context context, UUID itemID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        try {
            Item item = (Item)itemService.find(context, itemID);
            if (item != null) {
                curator.curate(context, item.getHandle());
            }
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)true);
        }
        catch (Exception e) {
            curator.setResult(task, e.getMessage());
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)false);
        }
    }

    public static FlowResult processQueueItem(Context context, UUID itemID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        String objId = String.valueOf(itemID);
        String taskQueueName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.ui.queuename");
        boolean status = false;
        Item item = (Item)itemService.find(context, itemID);
        if (item != null) {
            objId = item.getHandle();
            try {
                curator.queue(context, objId, taskQueueName);
                status = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult((String)task, (boolean)status, (String)objId, (String)taskQueueName);
    }

    private static String[] parseName(String name) throws UIException {
        String[] parts = new String[3];
        String[] split = name.split("_");
        if (split.length == 2) {
            parts[0] = split[0];
            parts[1] = split[1];
            parts[2] = null;
        } else if (split.length == 3) {
            parts[0] = split[0];
            parts[1] = split[1];
            parts[2] = split[2];
        } else {
            throw new UIException("Unable to parse metedata field name: " + name);
        }
        return parts;
    }
}

