/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.xmlworkflow.AbstractXMLUIAction;
import org.dspace.app.xmlui.aspect.xmlworkflow.WorkflowXMLUIFactory;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.xml.sax.SAXException;

public class WorkflowTransformer
extends AbstractDSpaceTransformer {
    private AbstractXMLUIAction xmluiActionUI;
    private boolean authorized = true;
    private static Logger log = Logger.getLogger(WorkflowTransformer.class);
    protected XmlWorkflowItemService xmlWorkflowItemService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService();
    protected XmlWorkflowFactory workflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.authorized = true;
        try {
            String stepID = parameters.getParameter("stepID");
            String actionID = parameters.getParameter("actionID");
            int workflowID = parameters.getParameterAsInteger("workflowID");
            XmlWorkflowItem wfi = (XmlWorkflowItem)this.xmlWorkflowItemService.find(this.context, workflowID);
            Workflow wf = this.workflowFactory.getWorkflow(wfi.getCollection());
            Step step = wf.getStep(stepID);
            this.xmluiActionUI = (AbstractXMLUIAction)WorkflowXMLUIFactory.getActionInterface((String)actionID);
            this.authorized = step.getActionConfig(actionID).getProcessingAction().isAuthorized(this.context, (HttpServletRequest)ObjectModelHelper.getRequest((Map)objectModel), wfi);
            if (this.xmluiActionUI != null) {
                this.xmluiActionUI.setup(resolver, objectModel, src, parameters);
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"error while setting up workflowtransformer", (String)""), (Throwable)e);
            throw new ProcessingException("Something went wrong while setting up the workflow");
        }
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        if (!this.authorized) {
            throw new AuthorizeException("You are not authorized to perform this task");
        }
        this.xmluiActionUI.addBody(body);
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.xmluiActionUI.addOptions(options);
    }

    public void addUserMeta(UserMeta userMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.xmluiActionUI.addUserMeta(userMeta);
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.xmluiActionUI.addPageMeta(pageMeta);
    }

    public void recycle() {
        if (this.xmluiActionUI != null) {
            this.xmluiActionUI.recycle();
            this.xmluiActionUI = null;
        }
        super.recycle();
    }
}

