/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.EPerson;
import org.dspace.versioning.Version;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersioningService;

public class DeleteVersionsConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteVersionsConfirm.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.title");
    private static final Message T_trail = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.trail");
    private static final Message T_head1 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.head1");
    private static final Message T_para1 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.para1");
    private static final Message T_para2 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.para2");
    private static final Message T_column1 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.column1");
    private static final Message T_column2 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.column2");
    private static final Message T_column3 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.column3");
    private static final Message T_column4 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.column4");
    private static final Message T_column5 = DeleteVersionsConfirm.message((String)"xmlui.aspect.versioning.DeleteVersionsConfirm.column5");
    private static final Message T_submit_delete = DeleteVersionsConfirm.message((String)"xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteVersionsConfirm.message((String)"xmlui.general.cancel");
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, AuthorizeException, SQLException {
        Division main = this.createMainDivision(body);
        this.createTable(main);
        this.addButtons(main);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Division createMainDivision(Body body) throws WingException {
        Division main = body.addInteractiveDivision("versions-confirm-delete", this.contextPath + "/item/versionhistory", "post", "delete version");
        main.setHead(T_head1);
        Para helpPara = main.addPara();
        helpPara.addContent(T_para1);
        helpPara.addHighlight("bold").addContent(T_para2);
        return main;
    }

    private void createTable(Division main) throws WingException, SQLException {
        String idsString = this.parameters.getParameter("versionIDs", null);
        Table table = main.addTable("versions-confirm-delete", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        header.addCellContent(T_column5);
        for (String id : idsString.split(",")) {
            Version version = null;
            if (StringUtils.isNotBlank((String)id)) {
                version = this.versioningService.getVersion(this.context, Integer.parseInt(id));
            }
            if (version == null) continue;
            Row row = table.addRow();
            row.addCell().addContent(version.getVersionNumber());
            this.addItemIdentifier(row.addCell(), version.getItem());
            EPerson editor = version.getEPerson();
            row.addCell().addXref("mailto:" + editor.getEmail(), editor.getFullName());
            row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
            row.addCell().addContent(version.getSummary());
        }
    }

    private void addButtons(Division main) throws WingException {
        Para buttons = main.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
    }

    private void addItemIdentifier(Cell cell, Item item) throws WingException {
        String itemHandle = item.getHandle();
        List identifiers = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.size() > 0) {
            itemIdentifier = ((MetadataValue)identifiers.get(0)).getValue();
        }
        if (itemIdentifier != null) {
            cell.addXref(this.contextPath + "/resource/" + itemIdentifier, itemIdentifier);
        } else {
            cell.addXref(this.contextPath + "/handle/" + itemHandle, itemHandle);
        }
    }
}

