/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statisticsElasticSearch;

import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.statisticsElasticSearch.ReportGenerator;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.statistics.DataTermsFacet;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.ElasticSearchLoggerService;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElasticSearchStatsViewer
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(ElasticSearchStatsViewer.class);
    public static final String elasticStatisticsPath = "stats";
    private static ThreadLocal<DateFormat> monthAndYearFormat = new /* Unavailable Anonymous Inner Class!! */;
    private static ThreadLocal<DateFormat> dateFormat = new /* Unavailable Anonymous Inner Class!! */;
    private static Client client;
    private static Division division;
    private static DSpaceObject dso;
    private static Date dateStart;
    private static Date dateEnd;
    protected ElasticSearchLoggerService elasticSearchLoggerService = StatisticsServiceFactory.getInstance().getElasticSearchLoggerService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected static TermFilterBuilder justOriginals;
    protected static FacetBuilder facetTopCountries;
    protected static FacetBuilder facetMonthlyDownloads;
    protected static FacetBuilder facetTopBitstreamsAllTime;
    protected static FacetBuilder facetTopUSCities;
    protected static FacetBuilder facetTopUniqueIP;
    protected static FacetBuilder facetTopTypes;
    private static final Message T_dspace_home;
    private static final Message T_trail;

    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        pageMeta.addMetadata("title").addContent("Statistics Report for : " + dso.getName());
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath, (boolean)true);
        pageMeta.addTrail().addContent("View Statistics");
    }

    public ElasticSearchStatsViewer() {
    }

    public ElasticSearchStatsViewer(DSpaceObject dso, Date dateStart, Date dateEnd) {
        ElasticSearchStatsViewer.dso = dso;
        ElasticSearchStatsViewer.dateStart = dateStart;
        ElasticSearchStatsViewer.dateEnd = dateEnd;
        client = this.elasticSearchLoggerService.getClient();
    }

    public void addBody(Body body) throws WingException, SQLException {
        dso = HandleUtil.obtainHandle((Map)this.objectModel);
        client = this.elasticSearchLoggerService.getClient();
        division = body.addDivision("elastic-stats");
        division.setHead("Statistical Report for " + dso.getName());
        division.addHidden("containerName").setValue(dso.getName());
        division.addHidden("baseURLStats").setValue(this.contextPath + "/handle/" + dso.getHandle() + "/" + "stats");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String[] requestURIElements = request.getRequestURI().split("/");
        if (requestURIElements[requestURIElements.length - 1].trim().equalsIgnoreCase("stats")) {
            Calendar cal = Calendar.getInstance();
            dateEnd = cal.getTime();
            cal.roll(1, -5);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            dateStart = cal.getTime();
            division.addHidden("reportDepth").setValue("summary");
            String dateRange = "Last Five Years";
            division.addPara("Showing Data ( " + dateRange + " )");
            division.addHidden("timeRangeString").setValue("Data Range: " + dateRange);
            if (dateStart != null) {
                division.addHidden("dateStart").setValue(((DateFormat)dateFormat.get()).format(dateStart));
            }
            if (dateEnd != null) {
                division.addHidden("dateEnd").setValue(((DateFormat)dateFormat.get()).format(dateEnd));
            }
            this.showAllReports();
        } else {
            ReportGenerator reportGenerator = new ReportGenerator();
            reportGenerator.addReportGeneratorForm(division, request);
            dateStart = reportGenerator.getDateStart();
            dateEnd = reportGenerator.getDateEnd();
            String requestedReport = requestURIElements[requestURIElements.length - 1];
            log.info((Object)("Requested report is: " + requestedReport));
            division.addHidden("reportDepth").setValue("detail");
            String dateRange = "";
            if (dateStart != null && dateEnd != null) {
                dateRange = "from: " + ((DateFormat)dateFormat.get()).format(dateStart) + " to: " + ((DateFormat)dateFormat.get()).format(dateEnd);
            } else if (dateStart != null && dateEnd == null) {
                dateRange = "starting from: " + ((DateFormat)dateFormat.get()).format(dateStart);
            } else if (dateStart == null && dateEnd != null) {
                dateRange = "ending with: " + ((DateFormat)dateFormat.get()).format(dateEnd);
            } else if (dateStart == null && dateEnd == null) {
                dateRange = "All Data Available";
            }
            division.addPara("Showing Data ( " + dateRange + " )");
            division.addHidden("timeRangeString").setValue(dateRange);
            if (dateStart != null) {
                division.addHidden("dateStart").setValue(((DateFormat)dateFormat.get()).format(dateStart));
            }
            if (dateEnd != null) {
                division.addHidden("dateEnd").setValue(((DateFormat)dateFormat.get()).format(dateEnd));
            }
            division.addHidden("reportName").setValue(requestedReport);
            if (requestedReport.equalsIgnoreCase("topCountries")) {
                SearchRequestBuilder requestBuilder = this.facetedQueryBuilder(new FacetBuilder[]{facetTopCountries, facetTopUSCities});
                this.searchResponseToDRI(requestBuilder);
            } else if (requestedReport.equalsIgnoreCase("fileDownloads")) {
                SearchRequestBuilder requestBuilder = this.facetedQueryBuilder(facetMonthlyDownloads);
                this.searchResponseToDRI(requestBuilder);
            } else if (requestedReport.equalsIgnoreCase("topDownloads")) {
                SearchRequestBuilder requestBuilder = this.facetedQueryBuilder(new FacetBuilder[]{facetTopBitstreamsAllTime, this.facetTopBitstreamsLastMonth()});
                SearchResponse resp = this.searchResponseToDRI(requestBuilder);
                TermsFacet bitstreamsAllTimeFacet = (TermsFacet)resp.getFacets().facet(TermsFacet.class, "top_bitstreams_alltime");
                this.addTermFacetToTable(bitstreamsAllTimeFacet, division, "Bitstream", "Top Downloads (all time)");
                TermsFacet bitstreamsFacet = (TermsFacet)resp.getFacets().facet(TermsFacet.class, "top_bitstreams_lastmonth");
                this.addTermFacetToTable(bitstreamsFacet, division, "Bitstream", "Top Downloads for " + this.getLastMonthString());
            }
        }
    }

    public void showAllReports() throws WingException, SQLException {
        ArrayList<FacetBuilder> summaryFacets = new ArrayList<FacetBuilder>();
        summaryFacets.add(facetTopTypes);
        summaryFacets.add(facetTopUniqueIP);
        summaryFacets.add(facetTopCountries);
        summaryFacets.add(facetTopUSCities);
        summaryFacets.add(this.facetTopBitstreamsLastMonth());
        summaryFacets.add(facetTopBitstreamsAllTime);
        summaryFacets.add(facetMonthlyDownloads);
        SearchRequestBuilder requestBuilder = this.facetedQueryBuilder(summaryFacets);
        SearchResponse resp = this.searchResponseToDRI(requestBuilder);
        TermsFacet bitstreamsFacet = (TermsFacet)resp.getFacets().facet(TermsFacet.class, "top_bitstreams_lastmonth");
        this.addTermFacetToTable(bitstreamsFacet, division, "Bitstream", "Top Downloads for " + this.getLastMonthString());
        TermsFacet topBitstreamsFacet = (TermsFacet)resp.getFacets().facet(TermsFacet.class, "top_bitstreams_lastmonth");
        List termsFacetEntries = topBitstreamsFacet.getEntries();
        DataTermsFacet termsFacet = new DataTermsFacet();
        for (TermsFacet.Entry entry : termsFacetEntries) {
            termsFacet.addTermFacet(new DataTermsFacet.TermsFacet(entry.getTerm().string(), Integer.valueOf(entry.getCount())));
        }
        division.addHidden("jsonTopDownloads").setValue(termsFacet.toJson());
    }

    public FacetBuilder facetTopBitstreamsLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMinimum(5));
        String lowerBound = ((DateFormat)dateFormat.get()).format(calendar.getTime());
        calendar.set(5, calendar.getActualMaximum(5));
        String upperBound = ((DateFormat)dateFormat.get()).format(calendar.getTime());
        log.info((Object)("Lower:" + lowerBound + " -- Upper:" + upperBound));
        return FacetBuilders.termsFacet((String)"top_bitstreams_lastmonth").field("id").facetFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"type", (String)"BITSTREAM"), justOriginals, FilterBuilders.rangeFilter((String)"time").from((Object)lowerBound).to((Object)upperBound)}));
    }

    public String getLastMonthString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMinimum(5));
        return ((DateFormat)monthAndYearFormat.get()).format(calendar.getTime());
    }

    public SearchRequestBuilder facetedQueryBuilder(FacetBuilder facet) throws WingException {
        ArrayList<FacetBuilder> facetList = new ArrayList<FacetBuilder>();
        facetList.add(facet);
        return this.facetedQueryBuilder(facetList);
    }

    public SearchRequestBuilder facetedQueryBuilder(FacetBuilder ... facets) throws WingException {
        ArrayList<FacetBuilder> facetList = new ArrayList<FacetBuilder>();
        for (FacetBuilder facet : facets) {
            facetList.add(facet);
        }
        return this.facetedQueryBuilder(facetList);
    }

    public SearchRequestBuilder facetedQueryBuilder(List<FacetBuilder> facetList) {
        TermQueryBuilder termQuery = QueryBuilders.termQuery((String)this.getOwningText(dso), (Object)dso.getID());
        RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)"time").from((Object)dateStart).to((Object)dateEnd);
        FilteredQueryBuilder filteredQueryBuilder = QueryBuilders.filteredQuery((QueryBuilder)termQuery, (FilterBuilder)rangeFilter);
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{this.elasticSearchLoggerService.getIndexName()}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)filteredQueryBuilder).setSize(0);
        for (FacetBuilder facet : facetList) {
            searchRequestBuilder.addFacet(facet);
        }
        return searchRequestBuilder;
    }

    public SearchResponse searchResponseToDRI(SearchRequestBuilder searchRequestBuilder) throws WingException {
        division.addHidden("request").setValue(searchRequestBuilder.toString());
        SearchResponse resp = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (resp == null) {
            log.info((Object)"Elastic Search is down for searching.");
            division.addPara("Elastic Search seems to be down :(");
            return null;
        }
        division.addHidden("response").setValue(resp.toString());
        division.addDivision("chart_div");
        return resp;
    }

    private void addTermFacetToTable(TermsFacet termsFacet, Division division, String termName, String tableHeader) throws WingException, SQLException {
        List termsFacetEntries = termsFacet.getEntries();
        if (termName.equalsIgnoreCase("country")) {
            division.addDivision("chart_div_map");
        }
        Table facetTable = division.addTable("facet-" + termName, termsFacetEntries.size() + 1, 10);
        facetTable.setHead(tableHeader);
        Row facetTableHeaderRow = facetTable.addRow("header");
        if (termName.equalsIgnoreCase("bitstream")) {
            facetTableHeaderRow.addCellContent("Title");
            facetTableHeaderRow.addCellContent("Creator");
            facetTableHeaderRow.addCellContent("Publisher");
            facetTableHeaderRow.addCellContent("Date");
        } else {
            facetTableHeaderRow.addCell().addContent(termName);
        }
        facetTableHeaderRow.addCell().addContent("Count");
        if (termsFacetEntries.size() == 0) {
            facetTable.addRow().addCell().addContent("No Data Available");
            return;
        }
        for (TermsFacet.Entry facetEntry : termsFacetEntries) {
            Row row = facetTable.addRow();
            if (termName.equalsIgnoreCase("bitstream")) {
                Bitstream bitstream = (Bitstream)this.bitstreamService.findByIdOrLegacyId(this.context, facetEntry.getTerm().string());
                Item item = (Item)this.bitstreamService.getParentObject(this.context, (DSpaceObject)bitstream);
                row.addCell().addXref(this.contextPath + "/handle/" + item.getHandle(), item.getName());
                row.addCellContent(this.getFirstMetadataValue(item, "dc.creator"));
                row.addCellContent(this.getFirstMetadataValue(item, "dc.publisher"));
                row.addCellContent(this.getFirstMetadataValue(item, "dc.date.issued"));
            } else if (termName.equalsIgnoreCase("country")) {
                row.addCell("country", "data", "country").addContent(new Locale("en", facetEntry.getTerm().string()).getDisplayCountry());
            } else {
                row.addCell().addContent(facetEntry.getTerm().string());
            }
            row.addCell("count", "data", "count").addContent(facetEntry.getCount());
        }
    }

    private void addDateHistogramToTable(DateHistogramFacet monthlyDownloadsFacet, Division division, String termName, String termDescription) throws WingException {
        List monthlyFacetEntries = monthlyDownloadsFacet.getEntries();
        if (monthlyFacetEntries.size() == 0) {
            division.addPara("Empty result set for: " + termName);
            return;
        }
        Table monthlyTable = division.addTable(termName, monthlyFacetEntries.size(), 10);
        monthlyTable.setHead(termDescription);
        Row tableHeaderRow = monthlyTable.addRow("header");
        tableHeaderRow.addCell("date", "header", null).addContent("Month/Date");
        tableHeaderRow.addCell("count", "header", null).addContent("Count");
        for (DateHistogramFacet.Entry histogramEntry : monthlyFacetEntries) {
            Row dataRow = monthlyTable.addRow();
            Date facetDate = new Date(histogramEntry.getTime());
            dataRow.addCell("date", "data", "date").addContent(((DateFormat)dateFormat.get()).format(facetDate));
            dataRow.addCell("count", "data", "count").addContent("" + histogramEntry.getCount());
        }
    }

    private String getOwningText(DSpaceObject dso) {
        switch (dso.getType()) {
            case 2: {
                return "owningItem";
            }
            case 3: {
                return "owningColl";
            }
            case 4: {
                return "owningComm";
            }
        }
        return "";
    }

    private String getFirstMetadataValue(Item item, String metadataKey) {
        List dcValue = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataKey);
        if (dcValue.size() > 0) {
            return ((MetadataValue)dcValue.get(0)).getValue();
        }
        return "";
    }

    static {
        justOriginals = FilterBuilders.termFilter((String)"bundleName", (String)"ORIGINAL");
        facetTopCountries = FacetBuilders.termsFacet((String)"top_countries").field("country.untouched").size(150).facetFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{justOriginals, FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)"country.untouched", (String)""))}));
        facetMonthlyDownloads = FacetBuilders.dateHistogramFacet((String)"monthly_downloads").field("time").interval("month").facetFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"type", (String)"BITSTREAM"), justOriginals}));
        facetTopBitstreamsAllTime = FacetBuilders.termsFacet((String)"top_bitstreams_alltime").field("id").facetFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"type", (String)"BITSTREAM"), justOriginals}));
        facetTopUSCities = FacetBuilders.termsFacet((String)"top_US_cities").field("city.untouched").size(50).facetFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"countryCode", (String)"US"), justOriginals, FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)"city.untouched", (String)""))}));
        facetTopUniqueIP = FacetBuilders.termsFacet((String)"top_unique_ips").field("ip");
        facetTopTypes = FacetBuilders.termsFacet((String)"top_types").field("type");
        T_dspace_home = ElasticSearchStatsViewer.message((String)"xmlui.general.dspace_home");
        T_trail = ElasticSearchStatsViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.trail");
    }
}

