/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.commons.lang.reflect.FieldUtils;
import org.dspace.app.xmlui.aspect.general.PageNotFoundTransformer;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageNotFoundTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_title = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.title");
    private static final Message T_head = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.head");
    private static final Message T_para1 = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.para1");
    private static final Message T_go_home = PageNotFoundTransformer.message((String)"xmlui.general.go_home");
    private static final Message T_dspace_home = PageNotFoundTransformer.message((String)"xmlui.general.dspace_home");
    private SAXEvent bodyEvent;
    private boolean bodyEmpty;

    public void startDocument() throws SAXException {
        this.bodyEvent = null;
        this.bodyEmpty = false;
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.bodyEvent != null) {
            this.sendEvent(this.bodyEvent);
            this.bodyEvent = null;
        }
        if (WingConstants.DRI.URI.equals(namespaceURI) && "body".equals(localName)) {
            this.bodyEvent = SAXEvent.startElement((String)namespaceURI, (String)localName, (String)qName, (Attributes)attributes);
            return;
        }
        super.startElement(namespaceURI, localName, qName, attributes);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.bodyEvent != null && WingConstants.DRI.URI.equals(namespaceURI) && "body".equals(localName)) {
            this.bodyEmpty = true;
            this.sendEvent(this.bodyEvent);
            this.bodyEvent = null;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException, ResourceNotFoundException {
        if (!this.isRedirect() && this.bodyEmpty) {
            Division notFound = body.addDivision("page-not-found", "primary");
            notFound.setHead(T_head);
            notFound.addPara(T_para1);
            notFound.addPara().addXref(this.contextPath + "/", T_go_home);
            HttpServletResponse response = (HttpServletResponse)this.objectModel.get("httpresponse");
            response.setStatus(404);
        }
    }

    private boolean isRedirect() {
        HttpServletResponse response = (HttpServletResponse)this.objectModel.get("httpresponse");
        try {
            return (Integer)FieldUtils.readField((Object)response, (String)"statusCode", (boolean)true) == 307;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.bodyEmpty) {
            pageMeta.addMetadata("title").addContent(T_title);
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        }
    }

    public void sendEvent(SAXEvent event) throws SAXException {
        if (event.type == SAXEvent.EventType.START) {
            super.startElement(event.namespaceURI, event.localName, event.qName, event.attributes);
        } else if (event.type == SAXEvent.EventType.END) {
            super.endElement(event.namespaceURI, event.localName, event.qName);
        }
    }

    public void recycle() {
        this.bodyEvent = null;
        super.recycle();
    }
}

