/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.controlpanel;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.AbstractControlPanelTab;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.harvest.HarvestScheduler;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ControlPanelHarvestingTab
extends AbstractControlPanelTab {
    private static final Message T_harvest_scheduler_head = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_scheduler_head");
    private static final Message T_harvest_label_status = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_status");
    private static final Message T_harvest_status_refresh = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_status_refresh");
    private static final Message T_harvest_label_actions = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_actions");
    private static final Message T_harvest_submit_start = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_submit_start");
    private static final Message T_harvest_submit_reset = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_submit_reset");
    private static final Message T_harvest_submit_resume = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_submit_resume");
    private static final Message T_harvest_submit_pause = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_submit_pause");
    private static final Message T_harvest_submit_stop = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_submit_stop");
    private static final Message T_harvest_label_collections = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_collections");
    private static final Message T_harvest_label_active = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_active");
    private static final Message T_harvest_label_queued = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_queued");
    private static final Message T_harvest_label_oai_errors = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_errors");
    private static final Message T_harvest_label_internal_errors = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_internal_errors");
    private static final Message T_harvest_head_generator_settings = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_head_generator_settings");
    private static final Message T_harvest_label_oai_url = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_url");
    private static final Message T_harvest_label_oai_source = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_source");
    private static final Message T_harvest_head_harvester_settings = ControlPanelHarvestingTab.message((String)"xmlui.administrative.ControlPanel.harvest_head_harvester_settings");
    protected HarvestedCollectionService harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public void addBody(Map objectModel, Division div) throws WingException, SQLException {
        org.dspace.app.xmlui.wing.element.List harvesterControls = div.addList("oai-harvester-controls", "form");
        harvesterControls.setHead(T_harvest_scheduler_head);
        harvesterControls.addLabel(T_harvest_label_status);
        Item status = harvesterControls.addItem();
        status.addContent(HarvestScheduler.getStatus());
        status.addXref(this.web_link, T_harvest_status_refresh);
        harvesterControls.addLabel(T_harvest_label_actions);
        Item actionsItem = harvesterControls.addItem();
        if (HarvestScheduler.hasStatus((int)4)) {
            actionsItem.addButton("submit_harvest_start").setValue(T_harvest_submit_start);
            actionsItem.addButton("submit_harvest_reset").setValue(T_harvest_submit_reset);
        }
        if (HarvestScheduler.hasStatus((int)3)) {
            actionsItem.addButton("submit_harvest_resume").setValue(T_harvest_submit_resume);
        }
        if (HarvestScheduler.hasStatus((int)1) || HarvestScheduler.hasStatus((int)2)) {
            actionsItem.addButton("submit_harvest_pause").setValue(T_harvest_submit_pause);
        }
        if (!HarvestScheduler.hasStatus((int)4)) {
            actionsItem.addButton("submit_harvest_stop").setValue(T_harvest_submit_stop);
        }
        String baseURL = this.contextPath + "/admin/collection?collectionID=";
        harvesterControls.addLabel(T_harvest_label_collections);
        Item allCollectionsItem = harvesterControls.addItem();
        List allCollections = this.harvestedCollectionService.findAll(this.context);
        for (HarvestedCollection oaiCollection : allCollections) {
            allCollectionsItem.addXref(baseURL + oaiCollection.getCollection().getID(), oaiCollection.getCollection().getName());
        }
        harvesterControls.addLabel(T_harvest_label_active);
        Item busyCollectionsItem = harvesterControls.addItem();
        List busyCollections = this.harvestedCollectionService.findByStatus(this.context, 1);
        for (HarvestedCollection busyCollection : busyCollections) {
            busyCollectionsItem.addXref(baseURL + busyCollection.getCollection().getID(), busyCollection.getCollection().getName());
        }
        harvesterControls.addLabel(T_harvest_label_queued);
        Item queuedCollectionsItem = harvesterControls.addItem();
        List queuedCollections = this.harvestedCollectionService.findByStatus(this.context, 2);
        for (HarvestedCollection queuedCollection : queuedCollections) {
            queuedCollectionsItem.addXref(baseURL + queuedCollection.getCollection().getID(), queuedCollection.getCollection().getName());
        }
        harvesterControls.addLabel(T_harvest_label_oai_errors);
        Item oaiErrorsItem = harvesterControls.addItem();
        List oaiErrors = this.harvestedCollectionService.findByStatus(this.context, 3);
        for (HarvestedCollection oaiError : oaiErrors) {
            oaiErrorsItem.addXref(baseURL + oaiError.getCollection().getID(), oaiError.getCollection().getName());
        }
        harvesterControls.addLabel(T_harvest_label_internal_errors);
        Item internalErrorsItem = harvesterControls.addItem();
        List internalErrors = this.harvestedCollectionService.findByStatus(this.context, -1);
        for (HarvestedCollection internalError : internalErrors) {
            internalErrorsItem.addXref(baseURL + internalError.getCollection().getID(), internalError.getCollection().getName());
        }
        org.dspace.app.xmlui.wing.element.List generatorSettings = div.addList("oai-generator-settings");
        generatorSettings.setHead(T_harvest_head_generator_settings);
        generatorSettings.addLabel(T_harvest_label_oai_url);
        String oaiUrl = this.configurationService.getProperty("oai.url");
        if (!StringUtils.isEmpty((String)oaiUrl)) {
            generatorSettings.addItemXref(oaiUrl, oaiUrl);
        }
        generatorSettings.addLabel(T_harvest_label_oai_source);
        String oaiAuthoritativeSource = this.configurationService.getProperty("oai.ore.authoritative.source");
        if (!StringUtils.isEmpty((String)oaiAuthoritativeSource)) {
            generatorSettings.addItem(oaiAuthoritativeSource);
        } else {
            generatorSettings.addItem("oai");
        }
        org.dspace.app.xmlui.wing.element.List harvesterSettings = div.addList("oai-harvester-settings");
        harvesterSettings.setHead(T_harvest_head_harvester_settings);
        List harvesterKeys = this.configurationService.getPropertyKeys("harvester");
        for (String key : harvesterKeys) {
            harvesterSettings.addLabel(key);
            harvesterSettings.addItem(this.configurationService.getProperty(key) + " ");
        }
    }
}

