/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowCurationUtils {
    private static final Message T_curate_success_notice = new Message("default", "xmlui.administrative.FlowCurationUtils.curate_success_notice");
    private static final Message T_curate_fail_notice = new Message("default", "xmlui.administrative.FlowCurationUtils.curate_failed_notice");
    private static final Message T_queue_success_notice = new Message("default", "xmlui.administrative.FlowCurationUtils.queue_success_notice");
    private static final Message T_queue_fail_notice = new Message("default", "xmlui.administrative.FlowCurationUtils.queue_failed_notice");
    private static final Map<String, String> map = new HashMap();
    public static final String CURATE_TASK_NAMES = "ui.tasknames";
    public static final String CURATE_GROUP_NAMES = "ui.taskgroups";
    public static final String CURATE_GROUP_PREFIX = "ui.taskgroup";
    public static final String UNGROUPED_TASKS = "ungrouped";
    public static Map<String, String> allTasks = new LinkedHashMap();
    public static Map<String, String[]> groupedTasks = new LinkedHashMap();
    public static Map<String, String> groups = new LinkedHashMap();

    protected static Curator getCurator(String taskName) {
        if (taskName != null && taskName.length() == 0) {
            taskName = null;
        }
        Curator curator = new Curator();
        curator.addTask(taskName);
        curator.setInvoked(Curator.Invoked.INTERACTIVE);
        return curator;
    }

    protected static FlowResult getRunFlowResult(String taskName, Curator curator, boolean success) {
        String status;
        if (map.isEmpty()) {
            String[] statusCodes;
            for (String pair : statusCodes = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("curate.ui.statusmessages")) {
                String[] parts = pair.split("=");
                map.put(parts[0].trim(), parts[1].trim());
            }
        }
        if ((status = (String)map.get(String.valueOf(curator.getStatus(taskName)))) == null) {
            status = (String)map.get("other");
        }
        String result = curator.getResult(taskName);
        FlowResult flowResult = new FlowResult();
        flowResult.setOutcome(success);
        if (result == null) {
            result = "Nothing to do for this DSpace object.";
        }
        if (success) {
            flowResult.setHeader(new Message("default", "Task: " + FlowCurationUtils.getUITaskName((String)taskName)));
            flowResult.setMessage(T_curate_success_notice);
            flowResult.setCharacters("STATUS: " + status + ", RESULT: " + result);
        } else {
            flowResult.setHeader(new Message("default", "Task: " + FlowCurationUtils.getUITaskName((String)taskName)));
            flowResult.setMessage(T_curate_fail_notice);
            flowResult.setCharacters("STATUS: Failure, RESULT: " + result);
        }
        flowResult.setContinue(true);
        return flowResult;
    }

    protected static FlowResult getQueueFlowResult(String taskName, boolean status, String objId, String queueName) {
        FlowResult flowResult = new FlowResult();
        flowResult.setOutcome(status);
        if (status) {
            flowResult.setHeader(new Message("default", "Task: " + FlowCurationUtils.getUITaskName((String)taskName)));
            flowResult.setMessage(T_queue_success_notice);
            flowResult.setCharacters("RESULT: Object '" + objId + "' queued in '" + queueName + "' Queue");
        } else {
            flowResult.setHeader(new Message("default", "Task: " + FlowCurationUtils.getUITaskName((String)taskName)));
            flowResult.setMessage(T_queue_fail_notice);
            flowResult.setCharacters("RESULT: FAILED to queue Object '" + objId + "' in '" + queueName + "' Queue");
        }
        flowResult.setContinue(true);
        return flowResult;
    }

    protected static String getUITaskName(String taskID) {
        String[] tasks;
        for (String task : tasks = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("curate.ui.tasknames")) {
            String[] keyValuePair = task.split("=");
            if (keyValuePair == null || keyValuePair.length != 2 || !taskID.equals(keyValuePair[0].trim())) continue;
            return keyValuePair[1];
        }
        return taskID;
    }

    public static FlowResult processCurateObject(Context context, Request request) {
        String task = request.getParameter("curate_task");
        String objHandle = request.getParameter("identifier");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        FlowResult result = null;
        try {
            curator.curate(context, objHandle);
            result = FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)true);
        }
        catch (Exception e) {
            curator.setResult(task, e.getMessage());
            result = FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)false);
        }
        result.setParameter("curate_task", (Object)task);
        result.setParameter("identifier", (Object)objHandle);
        return result;
    }

    public static FlowResult processQueueObject(Context context, Request request) {
        String task = request.getParameter("curate_task");
        String objHandle = request.getParameter("identifier");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        String taskQueueName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.ui.queuename");
        boolean status = false;
        if (objHandle != null) {
            try {
                curator.queue(context, objHandle, taskQueueName);
                status = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult((String)task, (boolean)status, (String)objHandle, (String)taskQueueName);
    }

    public static void setupCurationTasks() {
        try {
            FlowCurationUtils.setAllTasks();
            FlowCurationUtils.setGroupedTasks();
            FlowCurationUtils.setGroups();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAllTasks() throws WingException, UnsupportedEncodingException {
        String[] properties;
        for (String property : properties = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("curate.ui.tasknames")) {
            String[] keyValuePair = property.split("=");
            allTasks.put(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
        }
    }

    public static void setGroups() throws WingException, UnsupportedEncodingException {
        String[] properties = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("curate.ui.taskgroups");
        if (properties != null) {
            for (String property : properties) {
                String[] keyValuePair = property.split("=");
                groups.put(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
            }
        }
    }

    public static void setGroupedTasks() throws WingException, UnsupportedEncodingException {
        if (groups.isEmpty()) {
            FlowCurationUtils.setGroups();
        }
        if (!groups.isEmpty()) {
            for (String key : groups.keySet()) {
                String[] properties = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("curate.ui.taskgroup." + key);
                groupedTasks.put(URLDecoder.decode(key, "UTF-8"), properties);
            }
        }
    }

    public static Select getGroupSelectOptions(Select select) throws WingException {
        for (String key : groups.keySet()) {
            select.addOption(key, (String)groups.get(key));
        }
        return select;
    }

    public static Select getTaskSelectOptions(Select select, String curateGroup) throws WingException {
        String[] values = null;
        Iterator iterator = null;
        if (groupedTasks.isEmpty()) {
            for (String key : allTasks.keySet()) {
                select.addOption(key, (String)allTasks.get(key));
            }
            return select;
        }
        for (String key : groupedTasks.keySet()) {
            values = (String[])groupedTasks.get(key);
            if (!key.equals(curateGroup)) continue;
            for (String value : values) {
                Iterator innerIterator = allTasks.keySet().iterator();
                while (innerIterator.hasNext()) {
                    String optionValue = ((String)innerIterator.next()).trim();
                    if (!optionValue.equals(value.trim())) continue;
                    String optionText = (String)allTasks.get(optionValue);
                    select.addOption(optionValue, optionText);
                }
            }
        }
        return select;
    }
}

