/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.RequestInfo;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";
    public static final String REQUEST_INTERRUPTED_HEADER = "dspace.request.interrupted.header";
    public static final String REQUEST_INTERRUPTED_MESSAGE = "dspace.request.interrupted.message";
    public static final String REQUEST_INTERRUPTED_CHARACTERS = "dspace.request.interrupted.characters";
    private static final String CURRENT_IP_ADDRESS = "dspace.user.ip";
    private static final String EFFECTIVE_USER_ID = "dspace.user.effective";
    private static final String AUTHENTICATED_USER_ID = "dspace.user.authenticated";

    public static Context authenticate(Map objectModel, String email, String password, String realm) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        } else {
            int explicitStatus = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, (String)realm, (HttpServletRequest)request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context authenticateImplicit(Map objectModel) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        }
        return context;
    }

    private static void logIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        int[] groupIDs;
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        if (!AuthorizeManager.isAdmin((Context)context) && !SystemwideAlerts.canUserStartSession()) {
            context.setCurrentUser(null);
            return;
        }
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute("dspace.user.ip", (Object)request.getRemoteAddr());
        session.setAttribute("dspace.user.effective", (Object)eperson.getID());
        session.setAttribute("dspace.user.authenticated", (Object)eperson.getID());
    }

    public static void logIn(Map objectModel, EPerson eperson) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Integer id = (Integer)session.getAttribute("dspace.user.effective");
            Integer realid = (Integer)session.getAttribute("dspace.user.authenticated");
            if (id != null) {
                boolean ipcheck = ConfigurationManager.getBooleanProperty((String)"xmlui.session.ipcheck", (boolean)true);
                String address = (String)session.getAttribute("dspace.user.ip");
                if (!ipcheck || address != null && address.equals(request.getRemoteAddr())) {
                    int[] groupIDs;
                    EPerson eperson = EPerson.find((Context)context, (int)id);
                    context.setCurrentUser(eperson);
                    if (!AuthorizeManager.isAdmin((Context)context) && !SystemwideAlerts.canUserMaintainSession()) {
                        EPerson realEPerson = EPerson.find((Context)context, (int)realid);
                        Group administrators = Group.find((Context)context, (int)1);
                        if (!administrators.isMember(realEPerson)) {
                            context.setCurrentUser(null);
                            return;
                        }
                    }
                    for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
                        context.setSpecialGroup(groupID);
                    }
                } else {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"ip_mismatch", (String)("id=" + id + ", request ip=" + request.getRemoteAddr() + ", session ip=" + address)));
                }
            }
        }
    }

    public static void loginAs(Context context, HttpServletRequest request, EPerson loginAs) throws SQLException, AuthorizeException {
        int[] groupIDs;
        if (!ConfigurationManager.getBooleanProperty((String)"webui.user.assumelogin", (boolean)false)) {
            return;
        }
        if (!AuthorizeManager.isAdmin((Context)context)) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.onlyAdmins");
        }
        HttpSession session = request.getSession(false);
        Integer authenticatedID = (Integer)session.getAttribute("dspace.user.authenticated");
        if (context.getCurrentUser().getID() != authenticatedID.intValue()) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.onlyAuthenticatedAdmins");
        }
        if (loginAs == null) {
            return;
        }
        Group administrators = Group.find((Context)context, (int)1);
        if (administrators.isMember(loginAs)) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.notAnotherAdmin");
        }
        context.setCurrentUser(loginAs);
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute("dspace.user.effective", (Object)loginAs.getID());
    }

    public static void logOut(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession();
        if (session.getAttribute("dspace.user.effective") != null && session.getAttribute("dspace.user.authenticated") != null) {
            Integer effectiveID = (Integer)session.getAttribute("dspace.user.effective");
            Integer authenticatedID = (Integer)session.getAttribute("dspace.user.authenticated");
            if (effectiveID.intValue() != authenticatedID.intValue()) {
                EPerson authenticatedUser = EPerson.find((Context)context, (int)authenticatedID);
                context.setCurrentUser(authenticatedUser);
                session.setAttribute("dspace.user.effective", (Object)authenticatedID);
                return;
            }
        }
        context.setCurrentUser(null);
        session.removeAttribute("dspace.user.effective");
        session.removeAttribute("dspace.user.authenticated");
        session.removeAttribute("dspace.user.ip");
    }

    public static boolean canSelfRegister(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        if (SystemwideAlerts.canUserStartSession()) {
            return AuthenticationManager.canSelfRegister((Context)context, (HttpServletRequest)request, (String)email);
        }
        return false;
    }

    public static boolean allowSetPassword(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        return AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)email);
    }

    public static EPerson createNewEperson(Map objectModel, String email) throws SQLException, AuthorizeException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        context.turnOffAuthorisationSystem();
        EPerson eperson = EPerson.create((Context)context);
        eperson.setEmail(email);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        eperson.update();
        context.restoreAuthSystemState();
        AuthenticationManager.initEPerson((Context)context, (HttpServletRequest)request, (EPerson)eperson);
        return eperson;
    }

    public static boolean isInterupptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        Object interruptedObject = session.getAttribute("dspace.request.interrupted");
        return interruptedObject instanceof RequestInfo;
    }

    public static void interruptRequest(Map objectModel, String header, String message, String characters) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        RequestInfo interruptedRequest = new RequestInfo(request);
        session.setAttribute("dspace.request.interrupted", (Object)interruptedRequest);
        session.setAttribute("dspace.request.resume", null);
        session.setAttribute("dspace.request.interrupted.header", (Object)header);
        session.setAttribute("dspace.request.interrupted.message", (Object)message);
        session.setAttribute("dspace.request.interrupted.characters", (Object)characters);
    }

    public static String resumeInterruptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        session.setAttribute("dspace.request.interrupted.header", null);
        session.setAttribute("dspace.request.interrupted.message", null);
        session.setAttribute("dspace.request.interrupted.characters", null);
        Object interruptedObject = session.getAttribute("dspace.request.interrupted");
        if (interruptedObject instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)interruptedObject;
            session.setAttribute("dspace.request.interrupted", null);
            session.setAttribute("dspace.request.resume", (Object)interruptedRequest);
            if (interruptedRequest.getServletPath() == null || interruptedRequest.getServletPath().length() == 0) {
                return interruptedRequest.getActualPath();
            }
            return interruptedRequest.getServletPath();
        }
        return null;
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute("dspace.request.resume");
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute("dspace.request.interrupted", null);
                session.setAttribute("dspace.request.resume", null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        return null != request.getSession().getAttribute("dspace.user.effective");
    }
}

