/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class ItemRequestForm
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static Logger log = Logger.getLogger(ItemRequestForm.class);
    private static final Message T_title = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.title");
    private static final Message T_dspace_home = ItemRequestForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.trail");
    private static final Message T_head = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.head");
    private static final Message T_para1 = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.para1");
    private static final Message T_login_para = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.login_para");
    private static final Message T_login = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.login");
    private static final Message T_requesterEmail = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.requesterEmail");
    private static final Message T_requesterEmail_help = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.requesterEmail_help");
    private static final Message T_requesterEmail_error = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.requesterEmail.error");
    private static final Message T_message = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.message");
    private static final Message T_message_error = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.message.error");
    private static final Message T_requesterName = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.requesterName");
    private static final Message T_requesterName_error = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.requesterName.error");
    private static final Message T_allFiles = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.allFiles");
    private static final Message T_files = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.files");
    private static final Message T_notAllFiles = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.notAllFiles");
    private static final Message T_submit = ItemRequestForm.message((String)"xmlui.ArtifactBrowser.ItemRequestForm.submit");

    public Serializable getKey() {
        String requesterName = this.parameters.getParameter("requesterName", "");
        String requesterEmail = this.parameters.getParameter("requesterEmail", "");
        String allFiles = this.parameters.getParameter("allFiles", "");
        String message = this.parameters.getParameter("message", "");
        String bitstreamId = this.parameters.getParameter("bitstreamId", "");
        return Long.valueOf(HashUtil.hash((String)(requesterName + "-" + requesterEmail + "-" + allFiles + "-" + message + "-" + bitstreamId)));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean firstVisit = Boolean.valueOf(request.getParameter("firstVisit"));
        Item item = (Item)dso;
        Division itemRequest = body.addInteractiveDivision("itemRequest-form", request.getRequestURI(), "post", "primary");
        itemRequest.setHead(T_head);
        if (this.context.getCurrentUser() == null) {
            Para loginPara = itemRequest.addPara();
            loginPara.addContent(T_login_para);
            itemRequest.addPara().addXref(this.contextPath + "/login", T_login);
            String header = this.parameters.getParameter("header", null);
            String message = this.parameters.getParameter("message", null);
            String characters = this.parameters.getParameter("characters", null);
            AuthenticationUtil.interruptRequest((Map)this.objectModel, (String)header, (String)message, (String)characters);
        } else {
            try {
                int bitstreamID = this.parameters.getParameterAsInteger("bitstreamId");
                Bitstream bitstream = Bitstream.find((Context)this.context, (int)bitstreamID);
                if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bitstream, (int)0)) {
                    String redirectURL = request.getContextPath() + "/bitstream/handle/" + item.getHandle() + "/" + bitstream.getName() + "?sequence=" + bitstream.getSequenceID();
                    HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redirectURL);
                }
            }
            catch (ParameterException e) {
                log.error((Object)e.getMessage());
            }
        }
        itemRequest.addPara(T_para1);
        Metadatum[] titleDC = item.getDC("title", null, "*");
        if (titleDC != null && titleDC.length > 0) {
            itemRequest.addPara(titleDC[0].value);
        }
        List form = itemRequest.addList("form", "form");
        Text requesterName = form.addItem().addText("requesterName");
        requesterName.setLabel(T_requesterName);
        requesterName.setValue(this.parameters.getParameter("requesterName", ""));
        Text requesterEmail = form.addItem().addText("requesterEmail");
        requesterEmail.setLabel(T_requesterEmail);
        requesterEmail.setHelp(T_requesterEmail_help);
        requesterEmail.setValue(this.parameters.getParameter("requesterEmail", ""));
        Radio radio = form.addItem().addRadio("allFiles");
        String selected = !this.parameters.getParameter("allFiles", "true").equalsIgnoreCase("false") ? "true" : "false";
        radio.setOptionSelected(selected);
        radio.setLabel(T_files);
        radio.addOption("true", T_allFiles);
        radio.addOption("false", T_notAllFiles);
        TextArea message = form.addItem().addTextArea("message");
        message.setLabel(T_message);
        message.setValue(this.parameters.getParameter("message", ""));
        form.addItem().addHidden("bitstreamId").setValue(this.parameters.getParameter("bitstreamId", ""));
        form.addItem().addButton("submit").setValue(T_submit);
        if (request.getParameter("submit") != null) {
            if (StringUtils.isEmpty((String)this.parameters.getParameter("requesterName", ""))) {
                requesterName.addError(T_requesterName_error);
            }
            if (StringUtils.isEmpty((String)this.parameters.getParameter("requesterEmail", ""))) {
                requesterEmail.addError(T_requesterEmail_error);
            }
            if (StringUtils.isEmpty((String)this.parameters.getParameter("message", ""))) {
                message.addError(T_message_error);
            }
        }
        itemRequest.addHidden("page").setValue(this.parameters.getParameter("page", "unknown"));
    }
}

