/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.xmlui.wing;

/**
 * A class representing an error generated by the Wing framework.
 * 
 * This particular variation indicates that the arguments passed to the Wing
 * framework were invalid for the context in which they were attempting to be
 * used.
 * 
 * @author Scott Phillips
 */
public class WingInvalidArgument extends WingException
{
    // Because exception is serializable.
    public static final long serialVersionUID = 1;

    public WingInvalidArgument(String message)
    {
        super(message, null);
    }

    public WingInvalidArgument(Throwable t)
    {
        super(t);
    }

    public WingInvalidArgument(String message, Throwable t)
    {
        super(message, t);
    }

}
