/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.MetadataElement;
import org.dspace.app.xmlui.wing.element.Trail;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class PageMeta
extends AbstractWingElement
implements WingMergeableElement,
MetadataElement {
    public static final String E_PAGE_META = "pageMeta";
    private boolean merged = false;
    private List<Metadata> metadatum = new ArrayList();
    private List<Trail> trails = new ArrayList();

    protected PageMeta(WingContext context) throws WingException {
        super(context);
    }

    public Metadata addMetadata(String element, String qualifier, String language, boolean allowMultiple) throws WingException {
        Metadata metadata = new Metadata(this.context, element, qualifier, language, allowMultiple);
        this.metadatum.add(metadata);
        return metadata;
    }

    public Metadata addMetadata(String element, String qualifier, String language) throws WingException {
        return this.addMetadata(element, qualifier, language, false);
    }

    public Metadata addMetadata(String element, String qualifier) throws WingException {
        return this.addMetadata(element, qualifier, null, false);
    }

    public Metadata addMetadata(String element) throws WingException {
        return this.addMetadata(element, null, null, false);
    }

    public Trail addTrail(String target, String rend) throws WingException {
        Trail trail = new Trail(this.context, target, rend);
        this.trails.add(trail);
        return trail;
    }

    public Trail addTrail() throws WingException {
        return this.addTrail(null, null);
    }

    public void addTrailLink(String target, String characters) throws WingException {
        Trail trail = this.addTrail(target, null);
        trail.addContent(characters);
    }

    public void addTrailLink(String target, Message message) throws WingException {
        Trail trail = this.addTrail(target, null);
        trail.addContent(message);
    }

    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        return E_PAGE_META.equals(localName);
    }

    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (WingConstants.DRI.URI.equals(namespace) && "trail".equals(localName)) {
            for (Trail trail : this.trails) {
                trail.dispose();
            }
            this.trails.clear();
        }
        if (WingConstants.DRI.URI.equals(namespace) && "metadata".equals(localName)) {
            String element = attributes.getValue("element");
            String qualifier = attributes.getValue("qualifier");
            String language = attributes.getValue("lang");
            ArrayList<Metadata> remove = new ArrayList<Metadata>();
            for (Metadata metadata : this.metadatum) {
                if (!metadata.equals(element, qualifier, language) || metadata.allowMultiple()) continue;
                remove.add(metadata);
            }
            for (Metadata metadata : remove) {
                metadata.dispose();
                this.metadatum.remove(metadata);
            }
        }
        return null;
    }

    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            this.startElement(contentHandler, namespaces, E_PAGE_META, null);
        }
        for (Metadata metadata : this.metadatum) {
            metadata.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Trail trail : this.trails) {
            trail.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_PAGE_META);
        }
    }

    public void dispose() {
        for (Metadata metadata : this.metadatum) {
            metadata.dispose();
        }
        for (Trail trail : this.trails) {
            trail.dispose();
        }
        this.trails.clear();
        this.trails = null;
        this.metadatum.clear();
        this.metadatum = null;
        super.dispose();
    }
}

