/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statisticsGoogleAnalytics;

import com.google.api.services.analytics.model.GaData;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.google.GoogleQueryManager;
import org.xml.sax.SAXException;

public class StatisticsGoogleAnalyticsTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.general.dspace_home");
    private static final Message T_head_title = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.title");
    private static final Message T_statisticsGoogleAnalytics_trail = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.trail");
    private static final Message T_start_date = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.dates.startDate");
    private static final Message T_end_date = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.dates.endDate");
    private static final Message T_refresh = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.dates.refresh");
    private static final Message T_page_views = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.pageViews.title");
    private static final Message T_downloads = StatisticsGoogleAnalyticsTransformer.message((String)"xmlui.statisticsGoogleAnalytics.downloads.title");
    private String startDateString = "";
    private String endDateString = "";
    private String handle;
    private static Logger log = Logger.getLogger(StatisticsGoogleAnalyticsTransformer.class);

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath, (boolean)true);
        }
        pageMeta.addTrailLink(this.contextPath + "/handle" + (dso != null && dso.getHandle() != null ? "/" + dso.getHandle() : "/google-stats"), T_statisticsGoogleAnalytics_trail);
        pageMeta.addMetadata("title").addContent(T_head_title);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar currentDate = Calendar.getInstance();
        String dateNow = formatter.format(currentDate.getTime());
        Calendar lastYearDate = Calendar.getInstance();
        lastYearDate.add(1, -1);
        String dateLastYear = formatter.format(lastYearDate.getTime());
        this.handle = HandleUtil.obtainHandle((Map)this.objectModel).getHandle();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.startDateString = request.getParameter("startDate") == null || request.getParameter("startDate").equals("") ? dateLastYear : request.getParameter("startDate");
        this.endDateString = request.getParameter("endDate") == null || request.getParameter("endDate").equals("") ? dateNow : request.getParameter("endDate");
        Division main = body.addDivision("main");
        main.setHead(T_head_title);
        Division selectDate = main.addInteractiveDivision("selectDate", "", "post");
        org.dspace.app.xmlui.wing.element.List dates = selectDate.addList("dates", "form");
        Text startDate = dates.addItem().addText("startDate");
        startDate.setLabel(T_start_date);
        startDate.setValue(this.startDateString);
        Text endDate = dates.addItem().addText("endDate");
        endDate.setLabel(T_end_date);
        endDate.setValue(this.endDateString);
        dates.addItem().addButton("refresh").setValue(T_refresh);
        Division results = main.addDivision("results");
        this.getGAStuff(results);
    }

    private void getGAStuff(Division results) throws IOException, WingException {
        GoogleQueryManager gqm = new GoogleQueryManager();
        GaData gaData = gqm.getPageViews(this.startDateString, this.endDateString, this.handle);
        List rows = gaData.getRows();
        Table pageViews = results.addTable("pageViews", rows.size(), 2);
        pageViews.setHead(T_page_views);
        for (List row : rows) {
            Row tableRow = pageViews.addRow();
            tableRow.addCellContent((String)row.get(0) + " / " + (String)row.get(1));
            tableRow.addCellContent((String)row.get(2));
        }
        gqm = new GoogleQueryManager();
        gaData = gqm.getBitstreamDownloads(this.startDateString, this.endDateString, this.handle);
        rows = gaData.getRows();
        Table bitstreamViews = results.addTable("downloads", rows.size(), 2);
        bitstreamViews.setHead(T_downloads);
        for (List row : rows) {
            Row tableRow = bitstreamViews.addRow();
            tableRow.addCellContent((String)row.get(0) + " / " + (String)row.get(1));
            tableRow.addCellContent((String)row.get(2));
        }
    }
}

