/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.handle;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class HandleResolverReader
extends AbstractReader
implements Recyclable {
    private static final Logger log = Logger.getLogger(HandleResolverReader.class);
    public static final String CONTENTTYPE = "application/json; charset=utf-8";
    private Request req;
    private Response resp;
    private String action;
    private String handle;
    private String prefix;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.req = ObjectModelHelper.getRequest((Map)objectModel);
        this.resp = ObjectModelHelper.getResponse((Map)objectModel);
        this.action = par.getParameter("action", "listprefixes");
        this.handle = par.getParameter("handle", null);
        this.prefix = par.getParameter("prefix", null);
        super.setup(resolver, objectModel, src, par);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Context context = null;
        try {
            context = ContextUtil.obtainContext((Map)this.objectModel);
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            throw new ProcessingException("Error in database conncetion.", (Throwable)ex);
        }
        Gson gson = new Gson();
        String jsonString = null;
        try {
            if (this.action.equals("resolve")) {
                if (StringUtils.isBlank((String)this.handle)) {
                    this.resp.sendError(400);
                    return;
                }
                String url = HandleManager.resolveToURL((Context)context, (String)this.handle);
                jsonString = url != null ? gson.toJson((Object)new String[]{url}) : gson.toJson(null);
            } else if (this.action.equals("listprefixes")) {
                ArrayList<String> prefixes = new ArrayList<String>();
                prefixes.add(HandleManager.getPrefix());
                String additionalPrefixes = ConfigurationManager.getProperty((String)"handle.additional.prefixes");
                if (StringUtils.isNotBlank((String)additionalPrefixes)) {
                    for (String apref : additionalPrefixes.split(",")) {
                        prefixes.add(apref.trim());
                    }
                }
                jsonString = gson.toJson(prefixes);
            } else if (this.action.equals("listhandles")) {
                if (ConfigurationManager.getBooleanProperty((String)"handle.hide.listhandles", (boolean)true)) {
                    this.resp.sendError(404);
                    return;
                }
                if (StringUtils.isBlank((String)this.prefix)) {
                    this.resp.sendError(400);
                    return;
                }
                List handlelist = HandleManager.getHandlesForPrefix((Context)context, (String)this.prefix);
                String[] handles = handlelist.toArray(new String[handlelist.size()]);
                jsonString = gson.toJson((Object)handles);
            }
        }
        catch (SQLException e) {
            log.error((Object)"SQLException: ", (Throwable)e);
            return;
        }
        try {
            ObjectModelHelper.getResponse((Map)this.objectModel).setHeader("Content-Type", CONTENTTYPE);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.out);
            this.out.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
    }

    public void recycle() {
        this.req = null;
        this.resp = null;
        this.action = null;
        this.handle = null;
        this.prefix = null;
        super.recycle();
    }
}

