/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery.recentSubmissions;

import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecentSubmissionUtils {
    private static final Logger log = Logger.getLogger(RecentSubmissionUtils.class);

    public static DiscoverResult getRecentlySubmittedItems(Context context, DSpaceObject dso, int offset) {
        try {
            DiscoverQuery queryArgs = new DiscoverQuery();
            DiscoveryConfiguration discoveryConfiguration = RecentSubmissionUtils.getDiscoveryConfiguration((DSpaceObject)dso);
            List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
            queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
            queryArgs.setDSpaceObjectFilter(2);
            DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration = RecentSubmissionUtils.getRecentSubmissionConfiguration((DiscoveryConfiguration)discoveryConfiguration);
            if (recentSubmissionConfiguration != null) {
                queryArgs.setMaxResults(recentSubmissionConfiguration.getMax());
                queryArgs.setStart(offset);
                String sortField = SearchUtils.getSearchService().toSortFieldIndex(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration.getType());
                if (sortField != null) {
                    queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
                }
                SearchService service = SearchUtils.getSearchService();
                return service.search(context, dso, queryArgs);
            }
            return null;
        }
        catch (SearchServiceException se) {
            log.error((Object)("Caught SearchServiceException while retrieving recent submission for: " + (dso == null ? "home page" : dso.getHandle())), (Throwable)se);
            return null;
        }
    }

    public static DiscoveryRecentSubmissionsConfiguration getRecentSubmissionConfiguration(DSpaceObject dso) {
        return RecentSubmissionUtils.getRecentSubmissionConfiguration((DiscoveryConfiguration)RecentSubmissionUtils.getDiscoveryConfiguration((DSpaceObject)dso));
    }

    public static DiscoveryRecentSubmissionsConfiguration getRecentSubmissionConfiguration(DiscoveryConfiguration discoveryConfiguration) {
        return discoveryConfiguration.getRecentSubmissionConfiguration();
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(DSpaceObject dso) {
        return SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
    }
}

