/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.util.MetadataExposure;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Hidden;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractSearch
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(AbstractSearch.class);
    private static final Message T_head1_community = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.head1_community");
    private static final Message T_head1_collection = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.head1_collection");
    private static final Message T_head1_none = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.head1_none");
    private static final Message T_no_results = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.no_results");
    private static final Message T_all_of_dspace = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.all_of_dspace");
    private static final Message T_sort_by_relevance = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.sort_by.relevance");
    private static final Message T_sort_by = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.sort_by.head");
    private static final Message T_rpp = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.rpp");
    private static final Message T_result_head_3 = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.head3");
    private static final Message T_result_head_2 = AbstractSearch.message((String)"xmlui.Discovery.AbstractSearch.head2");
    protected DiscoverResult queryResults;
    protected DiscoverQuery queryArgs;
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            String key = "";
            key = key + "-" + this.getParameterPage();
            key = key + "-" + this.getParameterRpp();
            key = key + "-" + this.getParameterSortBy();
            key = key + "-" + this.getParameterOrder();
            key = key + "-" + this.getParameterEtAl();
            DSpaceObject scope = this.getScope();
            if (scope != null) {
                key = key + "-" + scope.getHandle();
            }
            key = key + "-" + this.getQuery();
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject scope = this.getScope();
                validity.add(scope);
                this.performSearch(scope);
                List results = this.queryResults.getDspaceObjects();
                if (results != null) {
                    validity.add("total:" + this.queryResults.getTotalSearchResults());
                    validity.add("start:" + this.queryResults.getStart());
                    validity.add("size:" + results.size());
                    for (DSpaceObject dso : results) {
                        validity.add(dso);
                    }
                }
                Map facetResults = this.queryResults.getFacetResults();
                for (String facetField : facetResults.keySet()) {
                    List facetValues = (List)facetResults.get(facetField);
                    for (DiscoverResult.FacetResult facetResult : facetValues) {
                        validity.add(facetField + facetResult.getAsFilterQuery() + facetResult.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.validity = null;
            }
            this.logSearch();
        }
        return this.validity;
    }

    public abstract void addBody(Body var1) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException;

    protected void buildMainForm(Division searchDiv) throws WingException, SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        Division mainForm = searchDiv.addInteractiveDivision("main-form", this.getBasicUrl(), "post", "");
        String query = this.getQuery();
        mainForm.addHidden("search-result").setValue(Boolean.TRUE.toString());
        mainForm.addHidden("query").setValue(query);
        mainForm.addHidden("current-scope").setValue(dso == null ? "" : dso.getHandle());
        Map fqs = this.getParameterFilterQueries();
        if (fqs != null) {
            for (String parameter : fqs.keySet()) {
                String[] values = (String[])fqs.get(parameter);
                if (values == null) continue;
                for (String value : values) {
                    mainForm.addHidden(parameter).setValue(value);
                }
            }
        }
        mainForm.addHidden("rpp").setValue(this.getParameterRpp());
        Hidden sort_by = mainForm.addHidden("sort_by");
        if (!StringUtils.isBlank((String)request.getParameter("sort_by"))) {
            sort_by.setValue(request.getParameter("sort_by"));
        } else {
            sort_by.setValue("score");
        }
        Hidden order = mainForm.addHidden("order");
        if (this.getParameterOrder() != null) {
            order.setValue(request.getParameter("order"));
        } else {
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
            order.setValue(discoveryConfiguration.getSearchSortConfiguration().getDefaultSortOrder().toString());
        }
        if (!StringUtils.isBlank((String)request.getParameter("page"))) {
            mainForm.addHidden("page").setValue(request.getParameter("page"));
        }
    }

    protected abstract String getBasicUrl() throws SQLException;

    protected void buildSearchResultsDivision(Division search) throws IOException, SQLException, WingException, SearchServiceException {
        try {
            if (this.queryResults == null) {
                DSpaceObject scope = this.getScope();
                this.performSearch(scope);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.queryResults = null;
        }
        Division results = search.addDivision("search-results", "primary");
        this.buildSearchControls(results);
        DSpaceObject searchScope = this.getScope();
        if (this.queryResults != null && 0L < this.queryResults.getTotalSearchResults()) {
            int displayedResults = this.queryResults.getDspaceObjects().size();
            long totalResults = this.queryResults.getTotalSearchResults();
            float searchTime = (float)this.queryResults.getSearchTime() / 1000.0f % 60.0f;
            if (searchScope instanceof Community) {
                Community community = (Community)searchScope;
                String communityName = community.getMetadata("name");
                results.setHead(T_head1_community.parameterize(new Object[]{displayedResults, totalResults, communityName, Float.valueOf(searchTime)}));
            } else if (searchScope instanceof org.dspace.content.Collection) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)searchScope;
                String collectionName = collection.getMetadata("name");
                results.setHead(T_head1_collection.parameterize(new Object[]{displayedResults, totalResults, collectionName, Float.valueOf(searchTime)}));
            } else {
                results.setHead(T_head1_none.parameterize(new Object[]{displayedResults, totalResults, Float.valueOf(searchTime)}));
            }
        }
        if (this.queryResults != null && 0 < this.queryResults.getDspaceObjects().size()) {
            DiscoverResult.DSpaceObjectHighlightResult highlightedResults;
            int itemsTotal = (int)this.queryResults.getTotalSearchResults();
            int firstItemIndex = this.queryResults.getStart() + 1;
            int lastItemIndex = this.queryResults.getStart() + this.queryResults.getDspaceObjects().size();
            int currentPage = this.queryResults.getStart() / this.queryResults.getMaxResults() + 1;
            int pagesTotal = (int)((this.queryResults.getTotalSearchResults() - 1L) / (long)this.queryResults.getMaxResults()) + 1;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("page", "{pageNum}");
            String pageURLMask = this.generateURL(parameters);
            pageURLMask = this.addFilterQueriesToUrl(pageURLMask);
            results.setMaskedPagination(itemsTotal, firstItemIndex, lastItemIndex, currentPage, pagesTotal, pageURLMask);
            org.dspace.app.xmlui.wing.element.List dspaceObjectsList = null;
            dspaceObjectsList = results.addList("search-results-repository", "dsolist", "repository-search-results");
            ArrayList<DSpaceObject> commCollList = new ArrayList<DSpaceObject>();
            ArrayList<org.dspace.content.Item> itemList = new ArrayList<org.dspace.content.Item>();
            for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                if (resultDso.getType() == 4 || resultDso.getType() == 3) {
                    commCollList.add(resultDso);
                    continue;
                }
                if (resultDso.getType() != 2) continue;
                itemList.add((org.dspace.content.Item)resultDso);
            }
            if (CollectionUtils.isNotEmpty(commCollList)) {
                org.dspace.app.xmlui.wing.element.List commCollWingList = dspaceObjectsList.addList("comm-coll-result-list");
                commCollWingList.setHead(T_result_head_2);
                for (DSpaceObject dso : commCollList) {
                    highlightedResults = this.queryResults.getHighlightedResults(dso);
                    if (dso.getType() == 4) {
                        org.dspace.app.xmlui.wing.element.List communityMetadata = commCollWingList.addList(dso.getHandle() + ":community");
                        this.renderCommunity((Community)dso, highlightedResults, communityMetadata);
                        continue;
                    }
                    if (dso.getType() != 3) continue;
                    org.dspace.app.xmlui.wing.element.List collectionMetadata = commCollWingList.addList(dso.getHandle() + ":collection");
                    this.renderCollection((org.dspace.content.Collection)dso, highlightedResults, collectionMetadata);
                }
            }
            if (CollectionUtils.isNotEmpty(itemList)) {
                org.dspace.app.xmlui.wing.element.List itemWingList = dspaceObjectsList.addList("item-result-list");
                if (CollectionUtils.isNotEmpty(commCollList)) {
                    itemWingList.setHead(T_result_head_3);
                }
                for (org.dspace.content.Item resultDso : itemList) {
                    highlightedResults = this.queryResults.getHighlightedResults((DSpaceObject)resultDso);
                    this.renderItem(itemWingList, resultDso, highlightedResults);
                }
            }
        } else {
            results.addPara(T_no_results);
        }
    }

    protected String addFilterQueriesToUrl(String pageURLMask) throws UIException {
        Map filterQueryParams = this.getParameterFilterQueries();
        if (filterQueryParams != null) {
            StringBuilder maskBuilder = new StringBuilder(pageURLMask);
            for (String filterQueryParam : filterQueryParams.keySet()) {
                String[] filterQueryValues = (String[])filterQueryParams.get(filterQueryParam);
                if (filterQueryValues == null) continue;
                for (String filterQueryValue : filterQueryValues) {
                    maskBuilder.append("&").append(filterQueryParam).append("=").append(AbstractSearch.encodeForURL((String)filterQueryValue));
                }
            }
            pageURLMask = maskBuilder.toString();
        }
        return pageURLMask;
    }

    protected void renderItem(org.dspace.app.xmlui.wing.element.List dspaceObjectsList, org.dspace.content.Item item, DiscoverResult.DSpaceObjectHighlightResult highlightedResults) throws WingException, SQLException {
        List fullSnippets;
        MetadataField[] metadataFields;
        org.dspace.app.xmlui.wing.element.List itemList = dspaceObjectsList.addList(item.getHandle() + ":item");
        for (MetadataField metadataField : metadataFields = MetadataField.findAll((Context)this.context)) {
            String schema = MetadataSchema.find((Context)this.context, (int)metadataField.getSchemaID()).getName();
            if (MetadataExposure.isHidden((Context)this.context, (String)schema, (String)metadataField.getElement(), (String)metadataField.getQualifier())) continue;
            StringBuilder metadataKey = new StringBuilder();
            metadataKey.append(schema).append(".").append(metadataField.getElement());
            if (metadataField.getQualifier() != null) {
                metadataKey.append(".").append(metadataField.getQualifier());
            }
            StringBuilder itemName = new StringBuilder();
            itemName.append(item.getHandle()).append(":").append(metadataKey.toString());
            Object[] itemMetadata = item.getMetadata(schema, metadataField.getElement(), metadataField.getQualifier(), "*");
            if (ArrayUtils.isEmpty((Object[])itemMetadata)) continue;
            org.dspace.app.xmlui.wing.element.List metadataFieldList = itemList.addList(itemName.toString());
            for (Object metadataValue : itemMetadata) {
                String value = ((DCValue)metadataValue).value;
                this.addMetadataField(highlightedResults, metadataKey.toString(), metadataFieldList, value);
            }
        }
        if (highlightedResults != null && CollectionUtils.isNotEmpty((Collection)(fullSnippets = highlightedResults.getHighlightResults("fulltext")))) {
            StringBuilder itemName = new StringBuilder();
            itemName.append(item.getHandle()).append(":").append("fulltext");
            org.dspace.app.xmlui.wing.element.List fullTextFieldList = itemList.addList(itemName.toString());
            for (String snippet : fullSnippets) {
                this.addMetadataField(fullTextFieldList, snippet);
            }
        }
    }

    protected void renderCollection(org.dspace.content.Collection collection, DiscoverResult.DSpaceObjectHighlightResult highlightedResults, org.dspace.app.xmlui.wing.element.List collectionMetadata) throws WingException {
        String description = collection.getMetadata("introductory_text");
        String description_abstract = collection.getMetadata("short_description");
        String description_table = collection.getMetadata("side_bar_text");
        String identifier_uri = "http://hdl.handle.net/" + collection.getHandle();
        String provenance = collection.getMetadata("provenance_description");
        String rights = collection.getMetadata("copyright_text");
        String rights_license = collection.getMetadata("license");
        String title = collection.getMetadata("name");
        if (StringUtils.isNotBlank((String)description)) {
            this.addMetadataField(highlightedResults, "dc.description", collectionMetadata.addList(collection.getHandle() + ":dc.description"), description);
        }
        if (StringUtils.isNotBlank((String)description_abstract)) {
            this.addMetadataField(highlightedResults, "dc.description.abstract", collectionMetadata.addList(collection.getHandle() + ":dc.description.abstract"), description_abstract);
        }
        if (StringUtils.isNotBlank((String)description_table)) {
            this.addMetadataField(highlightedResults, "dc.description.tableofcontents", collectionMetadata.addList(collection.getHandle() + ":dc.description.tableofcontents"), description_table);
        }
        if (StringUtils.isNotBlank((String)identifier_uri)) {
            this.addMetadataField(highlightedResults, "dc.identifier.uri", collectionMetadata.addList(collection.getHandle() + ":dc.identifier.uri"), identifier_uri);
        }
        if (StringUtils.isNotBlank((String)provenance)) {
            this.addMetadataField(highlightedResults, "dc.provenance", collectionMetadata.addList(collection.getHandle() + ":dc.provenance"), provenance);
        }
        if (StringUtils.isNotBlank((String)rights)) {
            this.addMetadataField(highlightedResults, "dc.rights", collectionMetadata.addList(collection.getHandle() + ":dc.rights"), rights);
        }
        if (StringUtils.isNotBlank((String)rights_license)) {
            this.addMetadataField(highlightedResults, "dc.rights.license", collectionMetadata.addList(collection.getHandle() + ":dc.rights.license"), rights_license);
        }
        if (StringUtils.isNotBlank((String)title)) {
            this.addMetadataField(highlightedResults, "dc.title", collectionMetadata.addList(collection.getHandle() + ":dc.title"), title);
        }
    }

    protected void renderCommunity(Community community, DiscoverResult.DSpaceObjectHighlightResult highlightedResults, org.dspace.app.xmlui.wing.element.List communityMetadata) throws WingException {
        String description = community.getMetadata("introductory_text");
        String description_abstract = community.getMetadata("short_description");
        String description_table = community.getMetadata("side_bar_text");
        String identifier_uri = "http://hdl.handle.net/" + community.getHandle();
        String rights = community.getMetadata("copyright_text");
        String title = community.getMetadata("name");
        if (StringUtils.isNotBlank((String)description)) {
            this.addMetadataField(highlightedResults, "dc.description", communityMetadata.addList(community.getHandle() + ":dc.description"), description);
        }
        if (StringUtils.isNotBlank((String)description_abstract)) {
            this.addMetadataField(highlightedResults, "dc.description.abstract", communityMetadata.addList(community.getHandle() + ":dc.description.abstract"), description_abstract);
        }
        if (StringUtils.isNotBlank((String)description_table)) {
            this.addMetadataField(highlightedResults, "dc.description.tableofcontents", communityMetadata.addList(community.getHandle() + ":dc.description.tableofcontents"), description_table);
        }
        if (StringUtils.isNotBlank((String)identifier_uri)) {
            this.addMetadataField(highlightedResults, "dc.identifier.uri", communityMetadata.addList(community.getHandle() + ":dc.identifier.uri"), identifier_uri);
        }
        if (StringUtils.isNotBlank((String)rights)) {
            this.addMetadataField(highlightedResults, "dc.rights", communityMetadata.addList(community.getHandle() + ":dc.rights"), rights);
        }
        if (StringUtils.isNotBlank((String)title)) {
            this.addMetadataField(highlightedResults, "dc.title", communityMetadata.addList(community.getHandle() + ":dc.title"), title);
        }
    }

    protected void addMetadataField(DiscoverResult.DSpaceObjectHighlightResult highlightedResults, String metadataKey, org.dspace.app.xmlui.wing.element.List metadataFieldList, String value) throws WingException {
        if (value == null) {
            return;
        }
        if (highlightedResults != null && highlightedResults.getHighlightResults(metadataKey) != null) {
            block3: for (String highlight : highlightedResults.getHighlightResults(metadataKey)) {
                DiscoverHitHighlightingField highlightConfig = this.queryArgs.getHitHighlightingField(metadataKey);
                if (highlightConfig == null) {
                    highlightConfig = this.queryArgs.getHitHighlightingField("*");
                }
                switch (highlightConfig.getMaxChars()) {
                    case 0: {
                        if (!highlight.replaceAll("</?em>", "").equals(value.replace("\r", ""))) continue block3;
                        value = highlight;
                        continue block3;
                    }
                }
                if (!value.contains(highlight.replaceAll("</?em>", ""))) continue;
                value = highlight;
            }
        }
        this.addMetadataField(metadataFieldList, value);
    }

    protected void addMetadataField(org.dspace.app.xmlui.wing.element.List metadataFieldList, String value) throws WingException {
        Item metadataItem = metadataFieldList.addItem();
        while (value.contains("<em>") && value.contains("</em>")) {
            if (0 < value.indexOf("<em>")) {
                metadataItem.addContent(value.substring(0, value.indexOf("<em>")));
            }
            metadataItem.addHighlight("highlight").addContent(StringUtils.substringBetween((String)value, (String)"<em>", (String)"</em>"));
            value = StringUtils.substringAfter((String)value, (String)"</em>");
        }
        if (0 < value.length()) {
            metadataItem.addContent(value);
        }
    }

    protected void buildScopeList(Select scope) throws SQLException, WingException {
        block4: {
            Community[] communities;
            DSpaceObject scopeDSO;
            block5: {
                block3: {
                    scopeDSO = this.getScope();
                    if (scopeDSO != null) break block3;
                    scope.addOption("/", T_all_of_dspace);
                    scope.setOptionSelected("/");
                    for (Community community : Community.findAllTop((Context)this.context)) {
                        scope.addOption(community.getHandle(), community.getMetadata("name"));
                    }
                    break block4;
                }
                if (!(scopeDSO instanceof Community)) break block5;
                Community community = (Community)scopeDSO;
                scope.addOption("/", T_all_of_dspace);
                scope.addOption(community.getHandle(), community.getMetadata("name"));
                scope.setOptionSelected(community.getHandle());
                for (org.dspace.content.Collection collection : community.getCollections()) {
                    scope.addOption(collection.getHandle(), collection.getMetadata("name"));
                }
                break block4;
            }
            if (!(scopeDSO instanceof org.dspace.content.Collection)) break block4;
            org.dspace.content.Collection collection = (org.dspace.content.Collection)scopeDSO;
            scope.addOption("/", T_all_of_dspace);
            scope.addOption(collection.getHandle(), collection.getMetadata("name"));
            scope.setOptionSelected(collection.getHandle());
            for (Community community : communities = collection.getCommunities()[0].getAllParents()) {
                scope.addOption(community.getHandle(), community.getMetadata("name"));
            }
        }
    }

    public void performSearch(DSpaceObject scope) throws UIException, SearchServiceException {
        String sortOrder;
        if (this.queryResults != null) {
            return;
        }
        String query = this.getQuery();
        int page = this.getParameterPage();
        ArrayList<String> filterQueries = new ArrayList<String>();
        String[] fqs = this.getFilterQueries();
        if (fqs != null) {
            filterQueries.addAll(Arrays.asList(fqs));
        }
        this.queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
        this.queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
        if (filterQueries.size() > 0) {
            this.queryArgs.addFilterQueries(filterQueries.toArray(new String[filterQueries.size()]));
        }
        this.queryArgs.setMaxResults(this.getParameterRpp());
        String sortBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        DiscoverySortConfiguration searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
        if (sortBy == null) {
            sortBy = "score";
            if (searchSortConfiguration != null) {
                for (DiscoverySortFieldConfiguration sortFieldConfiguration : searchSortConfiguration.getSortFields()) {
                    if (!sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort())) continue;
                    sortBy = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                }
            }
        }
        if ((sortOrder = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order")) == null && searchSortConfiguration != null) {
            sortOrder = searchSortConfiguration.getDefaultSortOrder().toString();
        }
        if (sortOrder == null || sortOrder.equalsIgnoreCase("DESC")) {
            this.queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.desc);
        } else {
            this.queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.asc);
        }
        String groupBy = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        if (groupBy != null && !groupBy.equalsIgnoreCase("none")) {
            this.queryArgs.addProperty("collapse.field", groupBy);
            this.queryArgs.addProperty("collapse.threshold", "1");
            this.queryArgs.addProperty("collapse.includeCollapsedDocs.fl", "handle");
            this.queryArgs.addProperty("collapse.facet", "before");
            this.queryArgs.setSortField("dc.type", DiscoverQuery.SORT_ORDER.asc);
        }
        this.queryArgs.setQuery(query != null && !query.trim().equals("") ? query : null);
        if (page > 1) {
            this.queryArgs.setStart((page - 1) * this.queryArgs.getMaxResults());
        } else {
            this.queryArgs.setStart(0);
        }
        if (discoveryConfiguration.getHitHighlightingConfiguration() != null) {
            List metadataFields = discoveryConfiguration.getHitHighlightingConfiguration().getMetadataFields();
            for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : metadataFields) {
                this.queryArgs.addHitHighlightingField(new DiscoverHitHighlightingField(fieldConfiguration.getField(), fieldConfiguration.getMaxSize(), fieldConfiguration.getSnippets()));
            }
        }
        this.queryArgs.setSpellCheck(discoveryConfiguration.isSpellCheckEnabled());
        this.queryResults = SearchUtils.getSearchService().search(this.context, scope, this.queryArgs);
    }

    protected Map<String, String[]> getParameterFilterQueries() {
        try {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            result.put("fq", ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq"));
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getFilterQueries() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fq");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String[] getFacetsList() {
        try {
            return ObjectModelHelper.getRequest((Map)this.objectModel).getParameterValues("fl");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int getParameterPage() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("page"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getParameterRpp() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    protected String getParameterSortBy() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by");
        return s != null ? s : null;
    }

    protected String getParameterGroup() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("group_by");
        return s != null ? s : "none";
    }

    protected String getParameterOrder() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
    }

    protected String getParameterScope() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("scope");
    }

    protected int getParameterEtAl() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("etal"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected boolean variableScope() throws SQLException {
        return HandleUtil.obtainHandle((Map)this.objectModel) == null;
    }

    protected abstract String getQuery() throws UIException;

    protected abstract String generateURL(Map<String, String> var1) throws UIException;

    public void recycle() {
        this.queryArgs = null;
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    protected void buildSearchControls(Division div) throws WingException, SQLException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
        Division searchControlsGear = div.addDivision("masked-page-control").addDivision("search-controls-gear", "controls-gear-wrapper");
        String currentSort = this.getParameterSortBy();
        org.dspace.app.xmlui.wing.element.List sortList = searchControlsGear.addList("sort-options", "simple", "gear-selection");
        sortList.addItem("sort-head", "gear-head first").addContent(T_sort_by);
        DiscoverySortConfiguration searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
        org.dspace.app.xmlui.wing.element.List sortOptions = sortList.addList("sort-selections");
        boolean selected = "score".equals(currentSort) || currentSort == null && searchSortConfiguration.getDefaultSort() == null;
        sortOptions.addItem("relevance", "gear-option" + (selected ? " gear-option-selected" : "")).addXref("sort_by=score&order=" + searchSortConfiguration.getDefaultSortOrder(), T_sort_by_relevance);
        if (searchSortConfiguration.getSortFields() != null) {
            for (DiscoverySortFieldConfiguration sortFieldConfiguration : searchSortConfiguration.getSortFields()) {
                String sortField = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                boolean selectedAsc = sortField.equals(currentSort) && "asc".equals(this.getParameterOrder()) || sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort()) && DiscoverySortConfiguration.SORT_ORDER.asc.equals((Object)searchSortConfiguration.getDefaultSortOrder());
                boolean selectedDesc = sortField.equals(currentSort) && "desc".equals(this.getParameterOrder()) || sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort()) && DiscoverySortConfiguration.SORT_ORDER.desc.equals((Object)searchSortConfiguration.getDefaultSortOrder());
                String sortFieldParam = "sort_by=" + sortField + "&order=";
                sortOptions.addItem(sortField, "gear-option" + (selectedAsc ? " gear-option-selected" : "")).addXref(sortFieldParam + "asc", AbstractSearch.message((String)("xmlui.Discovery.AbstractSearch.sort_by." + sortField + "_asc")));
                sortOptions.addItem(sortField, "gear-option" + (selectedDesc ? " gear-option-selected" : "")).addXref(sortFieldParam + "desc", AbstractSearch.message((String)("xmlui.Discovery.AbstractSearch.sort_by." + sortField + "_desc")));
            }
        }
        sortList.addItem("rpp-head", "gear-head").addContent(T_rpp);
        org.dspace.app.xmlui.wing.element.List rppOptions = sortList.addList("rpp-selections");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppOptions.addItem("rpp-" + i, "gear-option" + (i == this.getParameterRpp() ? " gear-option-selected" : "")).addXref("rpp=" + i, Integer.toString(i));
        }
    }

    protected DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    protected void logSearch() {
        int countCommunities = 0;
        int countCollections = 0;
        int countItems = 0;
        String logInfo = "";
        try {
            DSpaceObject dsoScope = this.getScope();
            if (dsoScope instanceof org.dspace.content.Collection) {
                logInfo = "collection_id=" + dsoScope.getID() + ",";
            } else if (dsoScope instanceof Community) {
                logInfo = "community_id=" + dsoScope.getID() + ",";
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"search", (String)(logInfo + "query=\"" + (this.queryArgs == null ? "" : this.queryArgs.getQuery()) + "\",results=(" + countCommunities + "," + countCollections + "," + countItems + ")")));
    }
}

