/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.xmlui.aspect.submission.StepAndPage;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowUtils {
    private static final Logger log = Logger.getLogger(FlowUtils.class);
    private static final String DSPACE_SUBMISSION_INFO = "dspace.submission.info";

    public static InProgressSubmission findSubmission(Context context, String inProgressSubmissionID) throws SQLException, AuthorizeException, IOException {
        char type = inProgressSubmissionID.charAt(0);
        int id = Integer.valueOf(inProgressSubmissionID.substring(1));
        if (type == 'S') {
            return WorkspaceItem.find((Context)context, (int)id);
        }
        if (type == 'W') {
            return WorkflowItem.find((Context)context, (int)id);
        }
        if (type == 'X') {
            return XmlWorkflowItem.find((Context)context, (int)id);
        }
        return null;
    }

    public static WorkspaceItem findWorkspace(Context context, String inProgressSubmissionID) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)inProgressSubmissionID);
        if (submission instanceof WorkspaceItem) {
            return (WorkspaceItem)submission;
        }
        return null;
    }

    public static SubmissionInfo obtainSubmissionInfo(Map objectModel, String workspaceID) throws SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext((Map)objectModel);
        SubmissionInfo subInfo = (SubmissionInfo)request.getAttribute("dspace.submission.info");
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)workspaceID);
        if (subInfo == null && submission != null || subInfo != null && submission != null && subInfo.getSubmissionItem().getID() != submission.getID()) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)objectModel.get("httprequest");
                subInfo = SubmissionInfo.load((HttpServletRequest)httpRequest, (InProgressSubmission)submission);
                context.setExtraLogInfo("session_id=" + request.getSession().getId());
                request.setAttribute("dspace.submission.info", (Object)subInfo);
            }
            catch (Exception e) {
                throw new SQLException("Error loading Submission Info: " + e.getMessage(), e);
            }
        } else if (subInfo == null && submission == null) {
            throw new SQLException("Unable to load Submission Information, since WorkspaceID (ID:" + workspaceID + ") is not a valid in-process submission.");
        }
        return subInfo;
    }

    public static void setPageReached(Context context, String id, int step, int page) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            if (step > workspaceItem.getStageReached()) {
                workspaceItem.setStageReached(step);
                workspaceItem.setPageReached(1);
                workspaceItem.update();
                context.commit();
            } else if (step == workspaceItem.getStageReached() && page > workspaceItem.getPageReached()) {
                workspaceItem.setPageReached(page);
                workspaceItem.update();
                context.commit();
            }
        }
    }

    public static void setBackPageReached(Context context, String id, int step, int page) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            workspaceItem.setStageReached(step);
            workspaceItem.setPageReached(page > 0 ? page : 1);
            workspaceItem.update();
            context.commit();
        }
    }

    public static int getMaximumStepReached(Context context, String id) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            int stage = workspaceItem.getStageReached();
            if (stage < 0) {
                stage = 0;
            }
            return stage;
        }
        return Integer.MAX_VALUE;
    }

    public static int getMaximumPageReached(Context context, String id) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission((Context)context, (String)id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            int page = workspaceItem.getPageReached();
            if (page < 0) {
                page = 0;
            }
            return page;
        }
        return Integer.MAX_VALUE;
    }

    public static int getStep(double stepAndPage) {
        String[] fields = Double.toString(stepAndPage).split("\\.");
        return Integer.parseInt(fields[0]);
    }

    public static int getPage(double stepAndPage) {
        String[] fields = Double.toString(stepAndPage).split("\\.");
        return Integer.parseInt(fields[1]);
    }

    public static void processSaveOrRemove(Context context, String id, Request request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter("submit_remove") != null) {
            WorkspaceItem workspace = FlowUtils.findWorkspace((Context)context, (String)id);
            workspace.deleteAll();
            context.commit();
        }
    }

    public static String getFieldName(DCInput input) {
        String dcSchema = input.getSchema();
        String dcElement = input.getElement();
        String dcQualifier = input.getQualifier();
        if (dcQualifier != null && !dcQualifier.equals("*")) {
            return dcSchema + "_" + dcElement + '_' + dcQualifier;
        }
        return dcSchema + "_" + dcElement;
    }

    public static StepAndPage[] getListOfAllSteps(HttpServletRequest request, SubmissionInfo subInfo) {
        ArrayList<StepAndPage> listStepNumbers = new ArrayList<StepAndPage>();
        for (int i = 0; i < subInfo.getSubmissionConfig().getNumberOfSteps(); ++i) {
            SubmissionStepConfig currentStep = subInfo.getSubmissionConfig().getStep(i);
            int stepNumber = currentStep.getStepNumber();
            if (currentStep.getId() != null && currentStep.getId().equals("collection")) continue;
            int numPages = 1;
            try {
                ClassLoader loader = subInfo.getClass().getClassLoader();
                Class<?> stepClass = loader.loadClass(currentStep.getProcessingClassName());
                AbstractProcessingStep step = (AbstractProcessingStep)stepClass.newInstance();
                numPages = step.getNumberOfPages(request, subInfo);
            }
            catch (Exception e) {
                log.error((Object)("Error loading step information from Step Class '" + currentStep.getProcessingClassName() + "' Error:"), (Throwable)e);
            }
            for (int j = 1; j <= numPages; ++j) {
                StepAndPage stepAndPageNum = new StepAndPage(stepNumber, j);
                listStepNumbers.add(stepAndPageNum);
            }
        }
        return listStepNumbers.toArray(new StepAndPage[listStepNumbers.size()]);
    }
}

