/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.Arrays;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Params
extends AbstractWingElement
implements StructuralElement {
    public static final String E_PARAMS = "params";
    public static final String A_OPERATIONS = "operations";
    public static final String A_RETURN_VALUE = "returnValue";
    public static final String A_SIZE = "size";
    public static final String A_EVTBEHAVIOR = "evtbehavior";
    public static final String A_MAX_LENGTH = "maxlength";
    public static final String A_MULTIPLE = "multiple";
    public static final String A_ROWS = "rows";
    public static final String A_COLS = "cols";
    public static final String A_AUTHORITY_CONTROLLED = "authorityControlled";
    public static final String A_AUTHORITY_REQUIRED = "authorityRequired";
    public static final String A_AUTOFOCUS = "autofocus";
    public static final String A_CHOICES = "choices";
    public static final String A_CHOICES_PRESENTATION = "choicesPresentation";
    public static final String A_CHOICES_CLOSED = "choicesClosed";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_DELETE = "delete";
    public static final String[] OPERATIONS = new String[]{"add", "delete"};
    public static final String PRESENTATION_SELECT = "select";
    public static final String PRESENTATION_SUGGEST = "suggest";
    public static final String PRESENTATION_LOOKUP = "lookup";
    public static final String PRESENTATION_NONE = "none";
    public static final String[] PRESENTATIONS = new String[]{"select", "suggest", "lookup", "none"};
    protected boolean addOperation;
    protected boolean deleteOperation;
    protected String returnValue;
    protected int size = -1;
    protected String evtBehavior = "";
    protected int maxlength = -1;
    protected boolean multiple = false;
    protected int rows = -1;
    protected int cols = -1;
    protected boolean authority = false;
    protected boolean authority_required = false;
    protected String autofocus = null;
    protected String choices = null;
    protected String presentation = null;
    protected boolean choicesClosed = false;

    protected Params(WingContext context) throws WingException {
        super(context);
    }

    public void enableAddOperation() throws WingException {
        this.addOperation = true;
    }

    public void enableDeleteOperation() throws WingException {
        this.deleteOperation = true;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setEvtBehavior(String behavior) {
        this.evtBehavior = behavior;
    }

    public void setMaxLength(int maxlength) {
        this.maxlength = maxlength;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setReturnValue(String returnValue) {
        this.returnValue = returnValue;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setAuthorityControlled() {
        this.authority = true;
    }

    public void setAuthorityControlled(boolean value) {
        this.authority = value;
    }

    public void setAuthorityRequired() {
        this.authority_required = true;
    }

    public void setAuthorityRequired(boolean value) {
        this.authority_required = value;
    }

    public void setAutofocus(String value) {
        this.autofocus = value;
    }

    public void setChoices(String fieldKey) {
        this.choices = fieldKey;
    }

    public void setChoicesPresentation(String value) throws WingException {
        this.restrict(value, PRESENTATIONS, "The 'presentation' parameter must be one of these values: " + Arrays.deepToString(PRESENTATIONS));
        this.presentation = value;
    }

    public void setChoicesClosed(boolean value) {
        this.choicesClosed = value;
    }

    public void setChoicesClosed() {
        this.choicesClosed = true;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        String operations = null;
        if (this.addOperation) {
            operations = operations == null ? OPERATION_ADD : operations + " add";
        }
        if (this.addOperation) {
            operations = operations == null ? OPERATION_DELETE : operations + " delete";
        }
        if (operations != null) {
            attributes.put((Object)A_OPERATIONS, (Object)operations);
        }
        if (this.returnValue != null) {
            attributes.put((Object)A_RETURN_VALUE, (Object)this.returnValue);
        }
        if (this.size > -1) {
            attributes.put(A_SIZE, this.size);
        }
        if (!this.evtBehavior.equals("")) {
            attributes.put((Object)A_EVTBEHAVIOR, (Object)this.evtBehavior);
        }
        if (this.maxlength > -1) {
            attributes.put(A_MAX_LENGTH, this.maxlength);
        }
        if (this.multiple) {
            attributes.put(A_MULTIPLE, this.multiple);
        }
        if (this.rows > -1) {
            attributes.put(A_ROWS, this.rows);
        }
        if (this.cols > -1) {
            attributes.put(A_COLS, this.cols);
        }
        if (this.authority) {
            attributes.put(A_AUTHORITY_CONTROLLED, this.authority);
        }
        if (this.authority_required) {
            attributes.put(A_AUTHORITY_REQUIRED, this.authority_required);
        }
        if (this.choices != null) {
            attributes.put((Object)A_CHOICES, (Object)this.choices);
        }
        if (this.presentation != null) {
            attributes.put((Object)A_CHOICES_PRESENTATION, (Object)this.presentation);
        }
        if (this.choicesClosed) {
            attributes.put(A_CHOICES_CLOSED, true);
        }
        if (this.autofocus != null) {
            attributes.put((Object)A_AUTOFOCUS, (Object)this.autofocus);
        }
        this.startElement(contentHandler, namespaces, E_PARAMS, attributes);
        this.endElement(contentHandler, namespaces, E_PARAMS);
    }
}

