/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.util.HashMap;
import java.util.Map;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.browse.BrowseItem;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.handle.HandleManager;

public class DSpaceObjectManager
implements ObjectManager {
    public boolean manageObject(Object object) {
        return object instanceof BrowseItem || object instanceof Item || object instanceof Collection || object instanceof Community;
    }

    public String getObjectURL(Object object) throws WingException {
        if (object instanceof DSpaceObject) {
            DSpaceObject dso = (DSpaceObject)object;
            String handle = dso.getHandle();
            if (handle != null) {
                return "/metadata/handle/" + handle + "/mets.xml";
            }
            if (dso instanceof Item || dso instanceof BrowseItem) {
                return "/metadata/internal/item/" + dso.getID() + "/mets.xml";
            }
            if (object instanceof Collection) {
                return "/metadata/internal/collection/" + dso.getID() + "/mets.xml";
            }
            if (object instanceof Community) {
                return "/metadata/internal/community/" + dso.getID() + "/mets.xml";
            }
        }
        return null;
    }

    public String getObjectType(Object object) {
        if (object instanceof Item || object instanceof BrowseItem) {
            return "DSpace Item";
        }
        if (object instanceof Collection) {
            return "DSpace Collection";
        }
        if (object instanceof Community) {
            return "DSpace Community";
        }
        return null;
    }

    public String getRepositoryIdentifier(Object object) throws WingException {
        return HandleManager.getPrefix();
    }

    public String getRepositoryURL(Object object) throws WingException {
        String handlePrefix = HandleManager.getPrefix();
        return "/metadata/internal/repository/" + handlePrefix + "/mets.xml";
    }

    public Map<String, String> getAllManagedRepositories() throws WingException {
        String handlePrefix = HandleManager.getPrefix();
        HashMap<String, String> allRepositories = new HashMap<String, String>();
        allRepositories.put(handlePrefix, "/metadata/internal/repository/" + handlePrefix + "/mets.xml");
        return allRepositories;
    }
}

