/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class AccessStepUtil
extends AbstractDSpaceTransformer {
    Context context = null;
    protected static final Message T_name = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.name");
    protected static final Message T_reason = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.reason");
    protected static final Message T_radios_embargo = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.embargo_visible");
    protected static final Message T_groups = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.list_assigned_groups");
    protected static final Message T_item_will_be_visible = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.open_access");
    protected static final Message T_item_embargoed = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.embargo");
    protected static final Message T_error_date_format = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.error_format_date");
    protected static final Message T_error_missing_date = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.error_missing_date");
    protected static final Message T_error_duplicated_policy = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.error_duplicated_policy");
    protected static final Message T_head_policies_table = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.table_policies");
    protected static final Message T_column0 = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.column0");
    protected static final Message T_column1 = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.column1");
    protected static final Message T_column2 = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.column2");
    protected static final Message T_column3 = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.column3");
    protected static final Message T_column4 = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.column4");
    protected static final Message T_table_submit_edit = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.table_edit_button");
    protected static final Message T_table_submit_delete = AccessStepUtil.message((String)"xmlui.Submission.submit.AccessStep.table_delete_button");
    private static final Message T_label_date_help = AccessStepUtil.message((String)"xmlui.administrative.authorization.AccessStep.label_date_help");
    public static final int RADIO_OPEN_ACCESS_ITEM_VISIBLE = 0;
    public static final int RADIO_OPEN_ACCESS_ITEM_EMBARGOED = 1;
    private String globalReason = null;
    private boolean isAdvancedFormEnabled = ConfigurationManager.getBooleanProperty((String)"xmlui.submission.restrictstep.enableAdvancedForm", (boolean)false);

    public AccessStepUtil(Context c) {
        this.context = c;
    }

    public void addName(String name_, org.dspace.app.xmlui.wing.element.List form, int errorFlag) throws WingException {
        if (this.isAdvancedFormEnabled) {
            Text name = form.addItem().addText("name");
            name.setLabel(T_name);
            if (name_ != null && errorFlag != 0) {
                name.setValue(name_);
            }
        }
    }

    public void addReason(String reason_, org.dspace.app.xmlui.wing.element.List form, int errorFlag) throws WingException {
        TextArea reason = form.addItem("reason", null).addTextArea("reason");
        reason.setLabel(T_reason);
        if (!this.isAdvancedFormEnabled) {
            if (this.globalReason != null) {
                reason.setValue(this.globalReason);
            }
        } else if (reason_ != null && errorFlag != 0) {
            reason.setValue(reason_);
        }
    }

    public void addListGroups(String groupID, org.dspace.app.xmlui.wing.element.List form, int errorFlag, Collection owningCollection) throws WingException, SQLException {
        if (this.isAdvancedFormEnabled) {
            Group uiGroup;
            form.addLabel(T_groups);
            Select groupSelect = form.addItem().addSelect("group_id");
            groupSelect.setMultiple(false);
            Group[] loadedGroups = null;
            String name = ConfigurationManager.getProperty((String)"xmlui.submission.restrictstep.groups");
            if (name != null && (uiGroup = Group.findByName((Context)this.context, (String)name)) != null) {
                loadedGroups = uiGroup.getMemberGroups();
            }
            if (loadedGroups == null || loadedGroups.length == 0) {
                loadedGroups = Group.findAll((Context)this.context, (int)1);
            }
            if (groupID == null || groupID.equals("")) {
                groupID = "0";
            }
            for (Group group : loadedGroups) {
                if (Integer.parseInt(groupID) == group.getID() && errorFlag != 0) {
                    groupSelect.addOption(true, group.getID(), group.getName());
                    continue;
                }
                groupSelect.addOption(false, group.getID(), group.getName());
            }
            if (errorFlag == 4 || errorFlag == 5 || errorFlag == 32 || errorFlag == 34) {
                groupSelect.addError(T_error_duplicated_policy);
            }
        }
    }

    public void addAccessRadios(String selectedRadio, String date, org.dspace.app.xmlui.wing.element.List form, int errorFlag, DSpaceObject dso) throws WingException, SQLException {
        if (!this.isAdvancedFormEnabled) {
            this.addEmbargoDateSimpleForm(dso, form, errorFlag);
        } else {
            org.dspace.app.xmlui.wing.element.Item radiosAndDate = form.addItem();
            Radio openAccessRadios = radiosAndDate.addRadio("open_access_radios");
            openAccessRadios.setLabel(T_radios_embargo);
            if (selectedRadio != null && Integer.parseInt(selectedRadio) == 1 && errorFlag != 0) {
                openAccessRadios.addOption(0, T_item_will_be_visible);
                openAccessRadios.addOption(true, 1, T_item_embargoed);
            } else {
                openAccessRadios.addOption(true, 0, T_item_will_be_visible);
                openAccessRadios.addOption(1, T_item_embargoed);
            }
            Text startDate = radiosAndDate.addText("embargo_until_date");
            startDate.setLabel("");
            startDate.setHelp(T_label_date_help);
            if (errorFlag == 1) {
                startDate.addError(T_error_date_format);
            } else if (errorFlag == 2) {
                startDate.addError(T_error_missing_date);
            }
            if (date != null && errorFlag != 0) {
                startDate.setValue(date);
            }
        }
    }

    public void addEmbargoDateSimpleForm(DSpaceObject dso, org.dspace.app.xmlui.wing.element.List form, int errorFlag) throws SQLException, WingException {
        List policies;
        String date = null;
        if (dso != null && (policies = AuthorizeManager.findPoliciesByDSOAndType((Context)this.context, (DSpaceObject)dso, (String)ResourcePolicy.TYPE_CUSTOM)).size() > 0) {
            ResourcePolicy rp = (ResourcePolicy)policies.get(0);
            if (rp.getStartDate() != null) {
                date = DateFormatUtils.format((Date)rp.getStartDate(), (String)"yyyy-MM-dd");
            }
            this.globalReason = rp.getRpDescription();
        }
        Text startDate = form.addItem().addText("embargo_until_date");
        startDate.setLabel(T_item_embargoed);
        if (errorFlag == 1) {
            startDate.addError(T_error_date_format);
        } else if (errorFlag == 2) {
            startDate.addError(T_error_missing_date);
        }
        if (date != null) {
            startDate.setValue(date);
        }
        startDate.setHelp(T_label_date_help);
    }

    public void addTablePolicies(Division div, DSpaceObject dso) throws WingException, SQLException {
        if (this.isAdvancedFormEnabled) {
            List resourcePolicies = AuthorizeManager.findPoliciesByDSOAndType((Context)this.context, (DSpaceObject)dso, (String)ResourcePolicy.TYPE_CUSTOM);
            int cols = resourcePolicies.size();
            if (cols == 0) {
                cols = 1;
            }
            Table policies = div.addTable("policies", 6, cols);
            policies.setHead(T_head_policies_table);
            Row header = policies.addRow("header");
            header.addCellContent(T_column0);
            header.addCellContent(T_column1);
            header.addCellContent(T_column2);
            header.addCellContent(T_column3);
            header.addCellContent(T_column4);
            for (ResourcePolicy rp : resourcePolicies) {
                int id = rp.getID();
                String name = "";
                if (rp.getRpName() != null) {
                    name = rp.getRpName();
                }
                String action = rp.getActionText();
                if (dso instanceof Item) {
                    Item item = (Item)dso;
                    if (rp.getEPersonID() != -1 && rp.getEPersonID() != 0 && item.getSubmitter().getID() == rp.getEPersonID()) continue;
                }
                String group = "";
                if (rp.getGroup() != null) {
                    group = rp.getGroup().getName();
                }
                Row row = policies.addRow();
                row.addCellContent(name);
                row.addCellContent(action);
                row.addCellContent(group);
                String startDate = "";
                if (rp.getStartDate() != null) {
                    startDate = DateFormatUtils.format((Date)rp.getStartDate(), (String)"yyyy-MM-dd");
                }
                row.addCellContent(startDate);
                String endDate = "";
                if (rp.getEndDate() != null) {
                    endDate = DateFormatUtils.format((Date)rp.getEndDate(), (String)"yyyy-MM-dd");
                }
                row.addCellContent(endDate);
                Button edit = row.addCell().addButton("submit_edit_edit_policies_" + id);
                edit.setValue(T_table_submit_edit);
                Button delete = row.addCell().addButton("submit_delete_edit_policies_" + id);
                delete.setValue(T_table_submit_delete);
            }
        }
    }
}

