/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.statistics.Report;
import org.dspace.app.statistics.ReportGenerator;
import org.dspace.app.statistics.StatisticsLoader;
import org.dspace.app.xmlui.aspect.artifactbrowser.StatisticsViewer;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatisticsViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(StatisticsViewer.class);
    private static final Message T_dspace_home = StatisticsViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_choose_report = StatisticsViewer.message((String)"xmlui.ArtifactBrowser.StatisticsViewer.choose_month");
    private static final Message T_page_title = StatisticsViewer.message((String)"xmlui.ArtifactBrowser.StatisticsViewer.report.title");
    private static final Message T_empty_title = StatisticsViewer.message((String)"xmlui.ArtifactBrowser.StatisticsViewer.no_report.title");
    private static final Message T_empty_text = StatisticsViewer.message((String)"xmlui.ArtifactBrowser.StatisticsViewer.no_report.text");
    private static final SimpleDateFormat sdfDisplay = new SimpleDateFormat("MM'/'yyyy");
    private static final SimpleDateFormat sdfLink = new SimpleDateFormat("yyyy'-'M");
    private boolean initialised = false;
    private String reportDate = null;
    private SourceValidity validity;
    private static final int MAX_ENTRY_LENGTH = 50;
    private static final int MAX_LABEL_LENGTH = 100;

    public Serializable getKey() {
        this.initialise();
        if (this.reportDate != null) {
            return this.reportDate;
        }
        return "general";
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                this.initialise();
                boolean showReport = ConfigurationManager.getBooleanProperty((String)"report.public");
                if (!showReport) {
                    try {
                        showReport = AuthorizeManager.isAdmin((Context)this.context);
                    }
                    catch (SQLException sqle) {
                        log.error((Object)"Unable to check for administrator", (Throwable)sqle);
                    }
                }
                if (showReport) {
                    File analysisFile = null;
                    analysisFile = this.reportDate != null ? StatisticsLoader.getAnalysisFor((String)this.reportDate) : StatisticsLoader.getGeneralAnalysis();
                    if (analysisFile != null) {
                        DSpaceValidity newValidity = new DSpaceValidity();
                        newValidity.add(Long.toString(analysisFile.lastModified()));
                        newValidity.add("-");
                        newValidity.add(Long.toString(analysisFile.length()));
                        this.validity = newValidity.complete();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Date[] monthlyDates = StatisticsLoader.getMonthlyAnalysisDates();
        if (monthlyDates != null && monthlyDates.length > 0) {
            List statList = options.addList("statsreports");
            statList.setHead(T_choose_report);
            HashMap<String, String> params = new HashMap<String, String>();
            for (Date date : monthlyDates) {
                params.put("date", sdfLink.format(date));
                statList.addItemXref(AbstractDSpaceTransformer.generateURL((String)"statistics", params), sdfDisplay.format(date));
            }
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.initialise();
        pageMeta.addMetadata("title").addContent(T_page_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_page_title);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.initialise();
        boolean publicise = ConfigurationManager.getBooleanProperty((String)"report.public");
        if (!publicise && !AuthorizeManager.isAdmin((Context)this.context)) {
            throw new AuthorizeException();
        }
        File analysisFile = this.reportDate != null ? StatisticsLoader.getAnalysisFor((String)this.reportDate) : StatisticsLoader.getGeneralAnalysis();
        Division div = body.addDivision("statistics", "primary");
        if (analysisFile != null) {
            try {
                XMLUIReport myRep = new XMLUIReport(div);
                ReportGenerator.processReport((Context)this.context, (Report)myRep, (String)analysisFile.getCanonicalPath());
            }
            catch (Exception e) {
                throw new UIException((Throwable)e);
            }
        } else {
            div.setHead(T_empty_title);
            div.addPara(T_empty_text);
        }
    }

    private void initialise() {
        if (!this.initialised) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            this.reportDate = request.getParameter("date");
            this.initialised = true;
        }
    }

    public void recycle() {
        this.initialised = false;
        this.reportDate = null;
        this.validity = null;
        super.recycle();
    }

    private static String entry(String entry) {
        if (entry != null && entry.length() > 50) {
            entry = entry.substring(0, 47) + "...";
        }
        return entry;
    }

    private static String label(String label) {
        if (label != null && label.length() > 100) {
            label = label.substring(0, 97) + "...";
        }
        return label;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ String access$100(String x0) {
        return StatisticsViewer.label((String)x0);
    }

    static /* synthetic */ String access$200(String x0) {
        return StatisticsViewer.entry((String)x0);
    }
}

