/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_context_head = Navigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_context_create_version = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_create_version");
    private static final Message T_context_show_version_history = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_show_version_history");
    private SourceValidity validity;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        String key = this.context.getCurrentUser() != null ? this.context.getCurrentUser().getEmail() : "anonymous";
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    Group[] groups;
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add((DSpaceObject)this.eperson);
                    for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)this.eperson)) {
                        validity.add((DSpaceObject)group);
                    }
                    DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                    if (dso != null) {
                        validity.add(dso);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item;
        options.addList("browse");
        options.addList("account");
        List context = options.addList("context");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso == null) {
            dso = this.getItemById();
        }
        if (dso != null && dso.getType() == 2 && AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)(item = (Item)dso).getOwningCollection())) {
            boolean headAdded = false;
            if (this.isLatest(item) && item.isArchived()) {
                context.setHead(T_context_head);
                headAdded = true;
                context.addItem().addXref(this.contextPath + "/item/version?itemID=" + item.getID(), T_context_create_version);
            }
            if (this.hasVersionHistory(item)) {
                if (!headAdded) {
                    context.setHead(T_context_head);
                }
                context.addItem().addXref(this.contextPath + "/item/versionhistory?itemID=" + item.getID(), T_context_show_version_history);
            }
        }
    }

    private Item getItemById() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Item item = null;
        int itemId = Util.getIntParameter((HttpServletRequest)request, (String)"itemID");
        if (itemId != -1) {
            item = Item.find((Context)this.context, (int)itemId);
        }
        return item;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }

    private boolean isLatest(Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        VersionHistory history = versioningService.findVersionHistory(this.context, item.getID());
        return history == null || history.getLatestVersion().getItem().getID() == item.getID();
    }

    private boolean hasVersionHistory(Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        VersionHistory history = versioningService.findVersionHistory(this.context, item.getID());
        return history != null;
    }
}

