/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statistics;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.DatasetDSpaceObjectGenerator;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTimeGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.StatisticsDataVisits;
import org.dspace.statistics.content.StatisticsListing;
import org.dspace.statistics.content.StatisticsTable;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatisticsTransformer
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(StatisticsTransformer.class);
    private static final Message T_dspace_home = StatisticsTransformer.message((String)"xmlui.general.dspace_home");
    private static final Message T_head_title = StatisticsTransformer.message((String)"xmlui.statistics.title");
    private static final Message T_statistics_trail = StatisticsTransformer.message((String)"xmlui.statistics.trail");
    private static final String T_head_visits_total = "xmlui.statistics.visits.total";
    private static final String T_head_visits_month = "xmlui.statistics.visits.month";
    private static final String T_head_visits_views = "xmlui.statistics.visits.views";
    private static final String T_head_visits_countries = "xmlui.statistics.visits.countries";
    private static final String T_head_visits_cities = "xmlui.statistics.visits.cities";
    private static final String T_head_visits_bitstream = "xmlui.statistics.visits.bitstreams";
    private Date dateStart = null;
    private Date dateEnd = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public StatisticsTransformer(Date dateStart, Date dateEnd) {
        this.dateStart = dateStart;
        this.dateEnd = dateEnd;
        try {
            this.context = new Context();
        }
        catch (SQLException e) {
            log.error((Object)("Error getting context in StatisticsTransformer:" + e.getMessage()));
        }
    }

    public StatisticsTransformer() {
        try {
            this.context = new Context();
        }
        catch (SQLException e) {
            log.error((Object)("Error getting context in StatisticsTransformer:" + e.getMessage()));
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath, (boolean)true);
        }
        pageMeta.addTrailLink(this.contextPath + "/handle" + (dso != null && dso.getHandle() != null ? "/" + dso.getHandle() : "/statistics"), T_statistics_trail);
        pageMeta.addMetadata("title").addContent(T_head_title);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        try {
            if (dso != null) {
                this.renderViewer(body, dso);
            } else {
                this.renderHome(body);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void renderHome(Body body) throws WingException {
        Division home = body.addDivision("home", "primary repository");
        Division division = home.addDivision("stats", "secondary stats");
        division.setHead(T_head_title);
        try {
            StatisticsListing statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits());
            statListing.setTitle("xmlui.statistics.visits.total");
            statListing.setId("list1");
            DatasetDSpaceObjectGenerator dsoAxis = new DatasetDSpaceObjectGenerator();
            dsoAxis.addDsoChild(2, 10, false, -1);
            statListing.addDatasetGenerator((DatasetGenerator)dsoAxis);
            this.addDisplayListing(division, statListing);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while creating statistics for home page", (Throwable)e);
        }
    }

    public void renderViewer(Body body, DSpaceObject dso) throws WingException {
        DatasetTypeGenerator typeAxis;
        DatasetDSpaceObjectGenerator dsoAxis;
        StatisticsListing statListing;
        Division home = body.addDivision(Constants.typeText[dso.getType()].toLowerCase() + "-home", "primary repository " + Constants.typeText[dso.getType()].toLowerCase());
        Division division = home.addDivision("stats", "secondary stats");
        division.setHead(T_head_title);
        try {
            statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statListing.setTitle("xmlui.statistics.visits.total");
            statListing.setId("list1");
            DatasetDSpaceObjectGenerator dsoAxis2 = new DatasetDSpaceObjectGenerator();
            dsoAxis2.addDsoChild(dso.getType(), 10, false, -1);
            statListing.addDatasetGenerator((DatasetGenerator)dsoAxis2);
            this.addDisplayListing(division, statListing);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        try {
            StatisticsTable statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataVisits(dso));
            statisticsTable.setTitle("xmlui.statistics.visits.month");
            statisticsTable.setId("tab1");
            DatasetTimeGenerator timeAxis = new DatasetTimeGenerator();
            timeAxis.setDateInterval("month", "-6", "+1");
            statisticsTable.addDatasetGenerator((DatasetGenerator)timeAxis);
            dsoAxis = new DatasetDSpaceObjectGenerator();
            dsoAxis.addDsoChild(dso.getType(), 10, false, -1);
            statisticsTable.addDatasetGenerator((DatasetGenerator)dsoAxis);
            this.addDisplayTable(division, statisticsTable);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        if (dso instanceof Item) {
            Item item = (Item)dso;
            try {
                if (item.hasUploadedFiles()) {
                    StatisticsListing statsList = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
                    statsList.setTitle("xmlui.statistics.visits.bitstreams");
                    statsList.setId("list-bit");
                    dsoAxis = new DatasetDSpaceObjectGenerator();
                    dsoAxis.addDsoChild(0, 10, false, -1);
                    statsList.addDatasetGenerator((DatasetGenerator)dsoAxis);
                    this.addDisplayListing(division, statsList);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
            }
        }
        try {
            statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statListing.setTitle("xmlui.statistics.visits.countries");
            statListing.setId("list2");
            typeAxis = new DatasetTypeGenerator();
            typeAxis.setType("countryCode");
            typeAxis.setMax(10);
            statListing.addDatasetGenerator((DatasetGenerator)typeAxis);
            this.addDisplayListing(division, statListing);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        try {
            statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statListing.setTitle("xmlui.statistics.visits.cities");
            statListing.setId("list3");
            typeAxis = new DatasetTypeGenerator();
            typeAxis.setType("city");
            typeAxis.setMax(10);
            statListing.addDatasetGenerator((DatasetGenerator)typeAxis);
            this.addDisplayListing(division, statListing);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
    }

    private void addDisplayTable(Division mainDiv, StatisticsTable display) throws SAXException, WingException, SQLException, SolrServerException, IOException, ParseException {
        String title = display.getTitle();
        Dataset dataset = display.getDataset();
        if (dataset == null) {
            dataset = display.getDataset(this.context);
        }
        if (dataset != null) {
            int row;
            String[][] matrix = dataset.getMatrix();
            Division wrapper = mainDiv.addDivision("tablewrapper");
            Table table = wrapper.addTable("list-table", 1, 1, title == null ? "detailtable" : "tableWithTitle detailtable");
            if (title != null) {
                table.setHead(StatisticsTransformer.message((String)title));
            }
            Row headerRow = table.addRow();
            headerRow.addCell("spacer", "header", "labelcell");
            String[] cLabels = dataset.getColLabels().toArray(new String[0]);
            for (row = 0; row < cLabels.length; ++row) {
                Cell cell = headerRow.addCell("0-" + row + "-h", "header", "labelcell");
                cell.addContent(cLabels[row]);
            }
            for (row = 0; row < matrix.length; ++row) {
                Row valListRow = table.addRow();
                valListRow.addCell("" + row, "data", "labelcell").addContent((String)dataset.getRowLabels().get(row));
                for (int col = 0; col < matrix[row].length; ++col) {
                    Cell cell = valListRow.addCell(row + "-" + col, "data", "datacell");
                    cell.addContent(matrix[row][col]);
                }
            }
        }
    }

    private void addDisplayListing(Division mainDiv, StatisticsListing display) throws SAXException, WingException, SQLException, SolrServerException, IOException, ParseException {
        String title = display.getTitle();
        Dataset dataset = display.getDataset();
        if (dataset == null) {
            dataset = display.getDataset(this.context);
        }
        if (dataset != null) {
            String[][] matrix = dataset.getMatrix();
            Table table = mainDiv.addTable("list-table", matrix.length, 2, title == null ? "detailtable" : "tableWithTitle detailtable");
            if (title != null) {
                table.setHead(StatisticsTransformer.message((String)title));
            }
            Row headerRow = table.addRow();
            headerRow.addCell("", "header", "labelcell");
            headerRow.addCell("", "header", "labelcell").addContent(StatisticsTransformer.message((String)"xmlui.statistics.visits.views"));
            for (int col = 0; col < matrix[0].length; ++col) {
                Row valListRow = table.addRow();
                Cell catCell = valListRow.addCell(col + "1", "data", "labelcell");
                catCell.addContent((String)dataset.getColLabels().get(col));
                Cell valCell = valListRow.addCell(col + "2", "data", "datacell");
                valCell.addContent(matrix[0][col]);
            }
            if (!"".equals(display.getCss())) {
                List attrlist = mainDiv.addList("divattrs");
                attrlist.addItem("style", display.getCss());
            }
        }
    }
}

