/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.vehiclerouting.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.vehiclerouting.domain.VrpCustomer;
import org.drools.planner.examples.vehiclerouting.domain.VrpDepot;
import org.drools.planner.examples.vehiclerouting.domain.VrpLocation;
import org.drools.planner.examples.vehiclerouting.domain.VrpSchedule;
import org.drools.planner.examples.vehiclerouting.domain.VrpVehicle;
import org.drools.planner.examples.vehiclerouting.persistence.VehicleRoutingDaoImpl;

public class VehicleRoutingSolutionImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = ".vrp";

    public static void main(String[] args) {
        new VehicleRoutingSolutionImporter().convertAll();
    }

    public VehicleRoutingSolutionImporter() {
        super(new VehicleRoutingDaoImpl());
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new VrpScheduleInputBuilder();
    }

    public class VrpScheduleInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private VrpSchedule schedule;
        private int locationListSize;
        private int capacity;
        private Map<Long, VrpLocation> locationMap;
        private List<VrpDepot> depotList;

        public VrpScheduleInputBuilder() {
            super(VehicleRoutingSolutionImporter.this);
        }

        @Override
        public Solution readSolution() throws IOException {
            this.schedule = new VrpSchedule();
            this.schedule.setId(0L);
            this.readHeaders();
            this.readLocationList();
            this.readCustomerList();
            this.readDepotList();
            this.createVehicleList();
            this.readConstantLine("EOF");
            BigInteger possibleSolutionSize = this.factorial(this.schedule.getLocationList().size() - 1);
            String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
            VehicleRoutingSolutionImporter.this.logger.info("VrpSchedule {} has {} depots, {} vehicles and {} customers with a search space of {}.", new Object[]{this.getInputId(), this.schedule.getDepotList().size(), this.schedule.getVehicleList().size(), this.schedule.getCustomerList().size(), flooredPossibleSolutionSize});
            return this.schedule;
        }

        private void readHeaders() throws IOException {
            this.schedule.setName(this.readStringValue("NAME :"));
            this.readUntilConstantLine("TYPE : CVRP");
            this.locationListSize = this.readIntegerValue("DIMENSION :");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE :");
            if (!edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.capacity = this.readIntegerValue("CAPACITY :");
        }

        private void readLocationList() throws IOException {
            this.readConstantLine("NODE_COORD_SECTION");
            ArrayList<VrpLocation> locationList = new ArrayList<VrpLocation>(this.locationListSize);
            this.locationMap = new HashMap<Long, VrpLocation>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line.trim().replaceAll(" +", " "), 3);
                VrpLocation location = new VrpLocation();
                location.setId(Long.parseLong(lineTokens[0]));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                this.locationMap.put(location.getId(), location);
            }
            this.schedule.setLocationList(locationList);
        }

        private void readCustomerList() throws IOException {
            this.readConstantLine("DEMAND_SECTION");
            ArrayList<VrpCustomer> customerList = new ArrayList<VrpCustomer>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line.trim().replaceAll(" +", " "), 2);
                VrpCustomer customer = new VrpCustomer();
                long id = Long.parseLong(lineTokens[0]);
                customer.setId(id);
                VrpLocation location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The customer with id (" + id + ") has no location (" + location + ").");
                }
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[1]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.schedule.setCustomerList(customerList);
        }

        private void readDepotList() throws IOException {
            this.readConstantLine("DEPOT_SECTION");
            this.depotList = new ArrayList<VrpDepot>(this.locationListSize);
            long id = this.readLongValue();
            while (id != -1L) {
                VrpDepot depot = new VrpDepot();
                depot.setId(id);
                VrpLocation location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The depot with id (" + id + ") has no location (" + location + ").");
                }
                depot.setLocation(location);
                this.depotList.add(depot);
                id = this.readLongValue();
            }
            this.schedule.setDepotList(this.depotList);
        }

        private void createVehicleList() throws IOException {
            int vehicleListSize;
            String inputFileNameRegex;
            String inputFileName = this.inputFile.getName();
            if (!inputFileName.matches(inputFileNameRegex = "^.+\\-k(\\d+)\\.vrp$")) {
                throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") does not match the inputFileNameRegex (" + inputFileNameRegex + ").");
            }
            String vehicleListSizeString = inputFileName.replaceAll(inputFileNameRegex, "$1");
            try {
                vehicleListSize = Integer.parseInt(vehicleListSizeString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") has a vehicleListSizeString (" + vehicleListSizeString + ") that is not a number.", e);
            }
            ArrayList<VrpVehicle> vehicleList = new ArrayList<VrpVehicle>(vehicleListSize);
            long id = 0L;
            for (int i = 0; i < vehicleListSize; ++i) {
                VrpVehicle vehicle = new VrpVehicle();
                vehicle.setId(id);
                ++id;
                vehicle.setCapacity(this.capacity);
                vehicle.setDepot(this.depotList.get(0));
                vehicleList.add(vehicle);
            }
            this.schedule.setVehicleList(vehicleList);
        }
    }
}

