/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.planner.examples.pas.domain.Room;

public class BedDesignationDifficultyWeightFactory
implements SelectionSorterWeightFactory<PatientAdmissionSchedule, BedDesignation> {
    public Comparable createSorterWeight(PatientAdmissionSchedule schedule, BedDesignation bedDesignation) {
        int disallowedCount = 0;
        for (Room room : schedule.getRoomList()) {
            disallowedCount += room.countDisallowedAdmissionPart(bedDesignation.getAdmissionPart()) * room.getCapacity();
        }
        return new BedDesignationDifficultyWeight(bedDesignation, disallowedCount);
    }

    public static class BedDesignationDifficultyWeight
    implements Comparable<BedDesignationDifficultyWeight> {
        private final BedDesignation bedDesignation;
        private int nightCount;
        private int disallowedCount;

        public BedDesignationDifficultyWeight(BedDesignation bedDesignation, int disallowedCount) {
            this.bedDesignation = bedDesignation;
            this.nightCount = bedDesignation.getAdmissionPart().getNightCount();
            this.disallowedCount = disallowedCount;
        }

        @Override
        public int compareTo(BedDesignationDifficultyWeight other) {
            return new CompareToBuilder().append(this.nightCount, other.nightCount).append(this.disallowedCount, other.disallowedCount).append((Object)this.bedDesignation.getId(), (Object)other.bedDesignation.getId()).toComparison();
        }
    }
}

