/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nurserostering.domain.DayOfWeek;
import org.drools.planner.examples.nurserostering.domain.Shift;

@XStreamAlias(value="ShiftDate")
public class ShiftDate
extends AbstractPersistable {
    private int dayIndex;
    private String dateString;
    private DayOfWeek dayOfWeek;
    private List<Shift> shiftList;

    public int getDayIndex() {
        return this.dayIndex;
    }

    public void setDayIndex(int dayIndex) {
        this.dayIndex = dayIndex;
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public List<Shift> getShiftList() {
        return this.shiftList;
    }

    public void setShiftList(List<Shift> shiftList) {
        this.shiftList = shiftList;
    }

    public String determineNextDateString() {
        Date date;
        TimeZone LOCAL_TIMEZONE = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(LOCAL_TIMEZONE);
        calendar.clear();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setCalendar(calendar);
        try {
            date = dateFormat.parse(this.dateString);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Could not parse shiftDate (" + this + ")'s dateString (" + this.dateString + ").");
        }
        calendar.setTime(date);
        calendar.add(6, 1);
        return dateFormat.format(calendar.getTime());
    }

    public String getLabel() {
        return this.dayOfWeek.getLabel() + " " + this.dateString.substring(5).replaceAll("\\-", "/");
    }

    @Override
    public String toString() {
        return this.dateString + "(" + (Object)((Object)this.dayOfWeek) + ")";
    }

    public int getWeekendSundayIndex() {
        switch (this.dayOfWeek) {
            case MONDAY: {
                return this.dayIndex - 1;
            }
            case TUESDAY: {
                return this.dayIndex - 2;
            }
            case WEDNESDAY: {
                return this.dayIndex - 3;
            }
            case THURSDAY: {
                return this.dayIndex + 3;
            }
            case FRIDAY: {
                return this.dayIndex + 2;
            }
            case SATURDAY: {
                return this.dayIndex + 1;
            }
            case SUNDAY: {
                return this.dayIndex;
            }
        }
        throw new IllegalArgumentException("The dayOfWeek (" + (Object)((Object)this.dayOfWeek) + ") is not valid.");
    }
}

