/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

public class RoomChangeMove
implements Move {
    private Lecture lecture;
    private Room toRoom;

    public RoomChangeMove(Lecture lecture, Room toRoom) {
        this.lecture = lecture;
        this.toRoom = toRoom;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.lecture.getRoom(), (Object)this.toRoom);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new RoomChangeMove(this.lecture, this.lecture.getRoom());
    }

    public void doMove(ScoreDirector scoreDirector) {
        CurriculumCourseMoveHelper.moveRoom(scoreDirector, this.lecture, this.toRoom);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.lecture);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toRoom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RoomChangeMove) {
            RoomChangeMove other = (RoomChangeMove)o;
            return new EqualsBuilder().append((Object)this.lecture, (Object)other.lecture).append((Object)this.toRoom, (Object)other.toRoom).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lecture).append((Object)this.toRoom).toHashCode();
    }

    public String toString() {
        return this.lecture + " => " + this.toRoom;
    }
}

