/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.api.domain.solution.PlanningSolution;
import org.drools.planner.core.score.buildin.hardsoft.HardSoftScore;
import org.drools.planner.core.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="CloudBalance")
public class CloudBalance
extends AbstractPersistable
implements Solution<HardSoftScore> {
    private List<CloudComputer> computerList;
    private List<CloudProcess> processList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    private HardSoftScore score;

    public List<CloudComputer> getComputerList() {
        return this.computerList;
    }

    public void setComputerList(List<CloudComputer> computerList) {
        this.computerList = computerList;
    }

    @PlanningEntityCollectionProperty
    public List<CloudProcess> getProcessList() {
        return this.processList;
    }

    public void setProcessList(List<CloudProcess> processList) {
        this.processList = processList;
    }

    public HardSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<CloudComputer> facts = new ArrayList<CloudComputer>();
        facts.addAll(this.computerList);
        return facts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CloudBalance)) {
            return false;
        }
        CloudBalance other = (CloudBalance)o;
        if (this.processList.size() != other.processList.size()) {
            return false;
        }
        Iterator<CloudProcess> it = this.processList.iterator();
        Iterator<CloudProcess> otherIt = other.processList.iterator();
        while (it.hasNext()) {
            CloudProcess otherProcess;
            CloudProcess process = it.next();
            if (process.solutionEquals(otherProcess = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CloudProcess process : this.processList) {
            hashCodeBuilder.append(process.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

