/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.solver.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.solver.move.TravelingTournamentMoveHelper;

public class MatchChainRotationsMove
implements Move {
    private List<Match> firstMatchList;
    private List<Match> secondMatchList;

    public MatchChainRotationsMove(List<Match> firstMatchList, List<Match> secondMatchList) {
        this.firstMatchList = firstMatchList;
        this.secondMatchList = secondMatchList;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return true;
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        ArrayList<Match> inverseFirstMatchList = new ArrayList<Match>(this.firstMatchList);
        Collections.reverse(inverseFirstMatchList);
        ArrayList<Match> inverseSecondMatchList = new ArrayList<Match>(this.secondMatchList);
        Collections.reverse(inverseSecondMatchList);
        return new MatchChainRotationsMove(inverseFirstMatchList, inverseSecondMatchList);
    }

    public void doMove(ScoreDirector scoreDirector) {
        this.rotateList(scoreDirector, this.firstMatchList);
        if (!this.secondMatchList.isEmpty()) {
            this.rotateList(scoreDirector, this.secondMatchList);
        }
    }

    private void rotateList(ScoreDirector scoreDirector, List<Match> matchList) {
        Iterator<Match> it = matchList.iterator();
        Match previousMatch = it.next();
        Match match = null;
        Day firstDay = previousMatch.getDay();
        while (it.hasNext()) {
            match = it.next();
            TravelingTournamentMoveHelper.moveDay(scoreDirector, previousMatch, match.getDay());
            previousMatch = match;
        }
        TravelingTournamentMoveHelper.moveDay(scoreDirector, match, firstDay);
    }

    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Match> entities = new ArrayList<Match>(this.firstMatchList.size() + this.secondMatchList.size());
        entities.addAll(this.firstMatchList);
        entities.addAll(this.secondMatchList);
        return entities;
    }

    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Day> values = new ArrayList<Day>(this.firstMatchList.size() + this.secondMatchList.size());
        for (Match match : this.firstMatchList) {
            values.add(match.getDay());
        }
        for (Match match : this.secondMatchList) {
            values.add(match.getDay());
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchChainRotationsMove) {
            MatchChainRotationsMove other = (MatchChainRotationsMove)o;
            return new EqualsBuilder().append(this.firstMatchList, other.firstMatchList).append(this.secondMatchList, other.secondMatchList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.firstMatchList).append(this.secondMatchList).toHashCode();
    }

    public String toString() {
        return this.firstMatchList + " & " + this.secondMatchList;
    }
}

