/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.domain.Team;
import org.drools.planner.examples.travelingtournament.domain.TravelingTournament;
import org.drools.planner.examples.travelingtournament.persistence.TravelingTournamentDaoImpl;

public class TravelingTournamentSolutionImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        new TravelingTournamentSolutionImporter().convertAll();
    }

    public TravelingTournamentSolutionImporter() {
        super(new TravelingTournamentDaoImpl());
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new TravelingTournamentInputBuilder();
    }

    public class TravelingTournamentInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        @Override
        public Solution readSolution() throws IOException {
            TravelingTournament travelingTournament = new TravelingTournament();
            travelingTournament.setId(0L);
            int n = this.readN();
            this.readTeamList(travelingTournament, n);
            this.createDayList(travelingTournament, n);
            List<List<Integer>> outerDistanceList = this.readOuterDistanceList(travelingTournament);
            this.createMatchListAndSetDistancesInTeamList(travelingTournament, outerDistanceList);
            this.initializeMatchDays(travelingTournament);
            return travelingTournament;
        }

        private int readN() throws IOException {
            return Integer.parseInt(this.bufferedReader.readLine());
        }

        private void readTeamList(TravelingTournament travelingTournament, int n) throws IOException {
            ArrayList<Team> teamList = new ArrayList<Team>();
            for (int i = 0; i < n; ++i) {
                Team team = new Team();
                team.setId(Long.valueOf(i));
                team.setName(this.bufferedReader.readLine());
                team.setDistanceToTeamMap(new HashMap<Team, Integer>());
                teamList.add(team);
            }
            travelingTournament.setTeamList(teamList);
        }

        private List<List<Integer>> readOuterDistanceList(TravelingTournament travelingTournament) throws IOException {
            ArrayList<List<Integer>> outerDistanceList = new ArrayList<List<Integer>>();
            String line = this.bufferedReader.readLine();
            while (line != null && !line.replaceAll("\\s+", "").equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(line.replaceAll("\\s+", " ").trim());
                ArrayList<Integer> innerDistanceList = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    int distance = Integer.parseInt(tokenizer.nextToken());
                    innerDistanceList.add(distance);
                }
                outerDistanceList.add(innerDistanceList);
                line = this.bufferedReader.readLine();
            }
            return outerDistanceList;
        }

        private void createDayList(TravelingTournament travelingTournament, int n) {
            ArrayList<Day> dayList = new ArrayList<Day>();
            int daySize = (n - 1) * 2;
            Day previousDay = null;
            for (int i = 0; i < daySize; ++i) {
                Day day = new Day();
                day.setId(Long.valueOf(i));
                day.setIndex(i);
                dayList.add(day);
                if (previousDay != null) {
                    previousDay.setNextDay(day);
                }
                previousDay = day;
            }
            travelingTournament.setDayList(dayList);
        }

        private void createMatchListAndSetDistancesInTeamList(TravelingTournament travelingTournament, List<List<Integer>> outerDistanceList) {
            List<Team> teamList = travelingTournament.getTeamList();
            ArrayList<Match> matchList = new ArrayList<Match>();
            int i = 0;
            long matchId = 0L;
            for (Team homeTeam : teamList) {
                int j = 0;
                for (Team awayTeam : teamList) {
                    int distance = outerDistanceList.get(i).get(j);
                    homeTeam.getDistanceToTeamMap().put(awayTeam, distance);
                    if (i != j) {
                        Match match = new Match();
                        match.setId(matchId);
                        ++matchId;
                        match.setHomeTeam(homeTeam);
                        match.setAwayTeam(awayTeam);
                        matchList.add(match);
                    }
                    ++j;
                }
                ++i;
            }
            travelingTournament.setMatchList(matchList);
        }

        protected void initializeMatchDays(TravelingTournament travelingTournament) {
            int n = travelingTournament.getN();
            for (int i = 0; i < n - 1; ++i) {
                this.initializeMatchPairs(travelingTournament, n - 1, i, i);
            }
            int startA = 1;
            int startB = n - 2;
            while (startA < n - 1) {
                for (int i = 0; i < n - 1; ++i) {
                    int a = (startA + i) % (n - 1);
                    int b = (startB + i) % (n - 1);
                    this.initializeMatchPairs(travelingTournament, a, b, i);
                }
                startA += 2;
                startB -= 2;
            }
        }

        private void initializeMatchPairs(TravelingTournament travelingTournament, int a, int b, int i) {
            if (i % 6 >= 3) {
                int oldA = a;
                a = b;
                b = oldA;
            }
            Team aTeam = travelingTournament.getTeamList().get(a);
            Team bTeam = travelingTournament.getTeamList().get(b);
            Match m1 = this.findMatch(travelingTournament.getMatchList(), aTeam, bTeam);
            m1.setDay(travelingTournament.getDayList().get(i));
            Match m2 = this.findMatch(travelingTournament.getMatchList(), bTeam, aTeam);
            m2.setDay(travelingTournament.getDayList().get(i + travelingTournament.getN() - 1));
        }

        private Match findMatch(List<Match> matchList, Team homeTeam, Team awayTeam) {
            for (Match match : matchList) {
                if (!match.getHomeTeam().equals(homeTeam) || !match.getAwayTeam().equals(awayTeam)) continue;
                return match;
            }
            throw new IllegalStateException("Nothing found for: " + homeTeam + " and " + awayTeam);
        }
    }
}

