/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class EmployeeMultipleChangeMove
implements Move {
    private Employee fromEmployee;
    private List<ShiftAssignment> shiftAssignmentList;
    private Employee toEmployee;

    public EmployeeMultipleChangeMove(Employee fromEmployee, List<ShiftAssignment> shiftAssignmentList, Employee toEmployee) {
        this.fromEmployee = fromEmployee;
        this.shiftAssignmentList = shiftAssignmentList;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.fromEmployee, (Object)this.toEmployee);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new EmployeeMultipleChangeMove(this.toEmployee, this.shiftAssignmentList, this.fromEmployee);
    }

    public void doMove(ScoreDirector scoreDirector) {
        for (ShiftAssignment shiftAssignment : this.shiftAssignmentList) {
            if (!shiftAssignment.getEmployee().equals(this.fromEmployee)) {
                throw new IllegalStateException("The shiftAssignment (" + shiftAssignment + ") should have the same employee (" + this.fromEmployee + ") as the fromEmployee (" + this.fromEmployee + ").");
            }
            NurseRosteringMoveHelper.moveEmployee(scoreDirector, shiftAssignment, this.toEmployee);
        }
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.shiftAssignmentList);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.fromEmployee, this.toEmployee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeMultipleChangeMove) {
            EmployeeMultipleChangeMove other = (EmployeeMultipleChangeMove)o;
            return new EqualsBuilder().append((Object)this.fromEmployee, (Object)other.fromEmployee).append(this.shiftAssignmentList, other.shiftAssignmentList).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fromEmployee).append(this.shiftAssignmentList).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.shiftAssignmentList + " => " + this.toEmployee;
    }
}

