/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.vehiclerouting.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Random;
import javax.swing.JTabbedPane;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.SolverAndPersistenceFrame;
import org.drools.planner.examples.vehiclerouting.domain.VrpCustomer;
import org.drools.planner.examples.vehiclerouting.domain.VrpLocation;
import org.drools.planner.examples.vehiclerouting.domain.VrpSchedule;
import org.drools.planner.examples.vehiclerouting.swingui.VehicleRoutingWorldPanel;

public class VehicleRoutingPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png";
    private VehicleRoutingWorldPanel vehicleRoutingWorldPanel;
    private Random demandRandom = new Random(37L);
    private Long nextLocationId = null;

    public VehicleRoutingPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.vehicleRoutingWorldPanel = new VehicleRoutingWorldPanel(this);
        this.vehicleRoutingWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.vehicleRoutingWorldPanel);
        this.add((Component)tabbedPane, "Center");
    }

    public boolean isWrapInScrollPane() {
        return false;
    }

    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public VrpSchedule getSchedule() {
        return (VrpSchedule)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        VrpSchedule schedule = (VrpSchedule)solution;
        this.vehicleRoutingWorldPanel.resetPanel(schedule);
        this.resetNextLocationId();
    }

    private void resetNextLocationId() {
        long highestLocationId = 0L;
        for (VrpLocation location : this.getSchedule().getLocationList()) {
            if (highestLocationId >= location.getId()) continue;
            highestLocationId = location.getId();
        }
        this.nextLocationId = highestLocationId + 1L;
    }

    public void updatePanel(Solution solution) {
        VrpSchedule schedule = (VrpSchedule)solution;
        this.vehicleRoutingWorldPanel.updatePanel(schedule);
    }

    public void doMove(Move move) {
        this.solutionBusiness.doMove(move);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertLocationAndCustomer(double longitude, double latitude) {
        final VrpLocation newLocation = new VrpLocation();
        newLocation.setId(this.nextLocationId);
        Long l = this.nextLocationId;
        Long l2 = this.nextLocationId = Long.valueOf(this.nextLocationId + 1L);
        newLocation.setLongitude(longitude);
        newLocation.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newLocation ({}).", (Object)newLocation);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                VrpSchedule solution = (VrpSchedule)scoreDirector.getWorkingSolution();
                scoreDirector.beforeProblemFactAdded((Object)newLocation);
                solution.getLocationList().add(newLocation);
                scoreDirector.afterProblemFactAdded((Object)newLocation);
                VrpCustomer newCustomer = new VrpCustomer();
                newCustomer.setId(newLocation.getId());
                newCustomer.setLocation(newLocation);
                newCustomer.setDemand(VehicleRoutingPanel.this.demandRandom.nextInt(10) + 1);
                scoreDirector.beforeEntityAdded((Object)newCustomer);
                solution.getCustomerList().add(newCustomer);
                scoreDirector.afterEntityAdded((Object)newCustomer);
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }
}

