/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.business.SolutionBusiness;
import org.drools.planner.examples.common.swingui.ConstraintScoreMapDialog;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverAndPersistenceFrame
extends JFrame {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionBusiness solutionBusiness;
    private SolutionPanel solutionPanel;
    private ConstraintScoreMapDialog constraintScoreMapDialog;
    private List<Action> loadUnsolvedActionList;
    private List<Action> loadSolvedActionList;
    private Action terminateSolvingEarlyAction;
    private JCheckBox refreshScreenDuringSolvingCheckBox;
    private Action solveAction;
    private Action openAction;
    private Action saveAction;
    private Action importAction;
    private Action exportAction;
    private JProgressBar progressBar;
    private JLabel resultLabel;
    private ShowConstraintScoreMapDialogAction showConstraintScoreMapDialogAction;

    public SolverAndPersistenceFrame(SolutionBusiness solutionBusiness, SolutionPanel solutionPanel, String exampleName) {
        super(exampleName + " Drools Planner example");
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel = solutionPanel;
        solutionPanel.setSolutionBusiness(solutionBusiness);
        solutionPanel.setSolverAndPersistenceFrame(this);
        this.registerListeners();
        this.constraintScoreMapDialog = new ConstraintScoreMapDialog(this);
        this.constraintScoreMapDialog.setSolutionBusiness(solutionBusiness);
    }

    private void registerListeners() {
        this.solutionBusiness.registerForBestSolutionChanges(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
            }
        });
    }

    public void bestSolutionChanged() {
        Solution solution = this.solutionBusiness.getSolution();
        if (this.refreshScreenDuringSolvingCheckBox.isSelected()) {
            this.solutionPanel.updatePanel(solution);
            this.validate();
        }
        this.resultLabel.setText("Latest best score: " + solution.getScore());
    }

    public void init() {
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createButtonPanel(), "North");
        if (this.solutionPanel.isWrapInScrollPane()) {
            JScrollPane solutionScrollPane = new JScrollPane(this.solutionPanel);
            panel.add((Component)solutionScrollPane, "Center");
        } else {
            panel.add((Component)this.solutionPanel, "Center");
        }
        panel.add((Component)this.createScorePanel(), "South");
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(this.createLoadUnsolvedPanel());
        panel.add(this.createLoadSolvedPanel());
        panel.add(this.createProcessingPanel());
        return panel;
    }

    private JComponent createLoadUnsolvedPanel() {
        this.loadUnsolvedActionList = new ArrayList<Action>();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getUnsolvedFileList()) {
            LoadAction loadUnsolvedAction = new LoadAction(file);
            this.loadUnsolvedActionList.add(loadUnsolvedAction);
            panel.add(new JButton(loadUnsolvedAction));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createLoadSolvedPanel() {
        this.loadSolvedActionList = new ArrayList<Action>();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getSolvedFileList()) {
            LoadAction loadSolvedAction = new LoadAction(file);
            this.loadSolvedActionList.add(loadSolvedAction);
            panel.add(new JButton(loadSolvedAction));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createProcessingPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        this.solveAction = new SolveAction();
        this.solveAction.setEnabled(false);
        panel.add(new JButton(this.solveAction));
        this.terminateSolvingEarlyAction = new TerminateSolvingEarlyAction();
        this.terminateSolvingEarlyAction.setEnabled(false);
        panel.add(new JButton(this.terminateSolvingEarlyAction));
        this.refreshScreenDuringSolvingCheckBox = new JCheckBox("Refresh screen during solving", this.solutionPanel.isRefreshScreenDuringSolving());
        panel.add(this.refreshScreenDuringSolvingCheckBox);
        this.openAction = new OpenAction();
        this.openAction.setEnabled(true);
        panel.add(new JButton(this.openAction));
        this.saveAction = new SaveAction();
        this.saveAction.setEnabled(false);
        panel.add(new JButton(this.saveAction));
        this.importAction = new ImportAction();
        this.importAction.setEnabled(this.solutionBusiness.hasImporter());
        panel.add(new JButton(this.importAction));
        this.exportAction = new ExportAction();
        this.exportAction.setEnabled(false);
        panel.add(new JButton(this.exportAction));
        return panel;
    }

    private void setSolutionLoaded() {
        this.solveAction.setEnabled(true);
        this.saveAction.setEnabled(true);
        this.exportAction.setEnabled(this.solutionBusiness.hasExporter());
        this.resetScreen();
    }

    private void setSolvingState(boolean solving) {
        for (Action action : this.loadUnsolvedActionList) {
            action.setEnabled(!solving);
        }
        for (Action action : this.loadSolvedActionList) {
            action.setEnabled(!solving);
        }
        this.solveAction.setEnabled(!solving);
        this.terminateSolvingEarlyAction.setEnabled(solving);
        this.openAction.setEnabled(!solving);
        this.saveAction.setEnabled(!solving);
        this.importAction.setEnabled(!solving && this.solutionBusiness.hasImporter());
        this.exportAction.setEnabled(!solving && this.solutionBusiness.hasExporter());
        this.solutionPanel.setEnabled(!solving);
        this.progressBar.setIndeterminate(solving);
        this.progressBar.setStringPainted(solving);
        this.progressBar.setString(solving ? "Solving..." : null);
        this.showConstraintScoreMapDialogAction.setEnabled(!solving);
        this.solutionPanel.setSolvingState(solving);
    }

    private JPanel createScorePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        panel.add((Component)this.progressBar, "West");
        this.resultLabel = new JLabel("No solution loaded yet");
        this.resultLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.resultLabel, "Center");
        this.showConstraintScoreMapDialogAction = new ShowConstraintScoreMapDialogAction();
        JButton constraintScoreMapButton = new JButton(this.showConstraintScoreMapDialogAction);
        panel.add((Component)constraintScoreMapButton, "East");
        return panel;
    }

    public void resetScreen() {
        this.solutionPanel.resetPanel(this.solutionBusiness.getSolution());
        this.validate();
        this.resultLabel.setText("Score: " + this.solutionBusiness.getScore());
    }

    private class ShowConstraintScoreMapDialogAction
    extends AbstractAction {
        public ShowConstraintScoreMapDialogAction() {
            super("Constraint scores");
        }

        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.constraintScoreMapDialog.resetContentPanel();
            SolverAndPersistenceFrame.this.constraintScoreMapDialog.setVisible(true);
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("Export as...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir());
            int approved = fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.exportSolution(fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ImportAction
    extends AbstractAction {
        public ImportAction() {
            super("Import...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getImportDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || SolverAndPersistenceFrame.this.solutionBusiness.acceptImportFile(file);
                }

                public String getDescription() {
                    return "Import files (*" + SolverAndPersistenceFrame.this.solutionBusiness.getImportFileSuffix() + ")";
                }
            });
            int approved = fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.importSolution(fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save as...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return "Solver xml files";
                }
            });
            int approved = fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.saveSolution(fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getUnsolvedDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return "Solver xml files";
                }
            });
            int approved = fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.openSolution(fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class TerminateSolvingEarlyAction
    extends AbstractAction {
        public TerminateSolvingEarlyAction() {
            super("Terminate solving early");
        }

        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
        }
    }

    private class SolveAction
    extends AbstractAction {
        private ExecutorService solvingExecutor;

        public SolveAction() {
            super("Solve");
            this.solvingExecutor = Executors.newFixedThreadPool(1);
        }

        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setSolvingState(true);
            final Solution planningProblem = SolverAndPersistenceFrame.this.solutionBusiness.getSolution();
            this.solvingExecutor.submit(new Runnable(){

                public void run() {
                    Solution bestSolution;
                    try {
                        bestSolution = SolverAndPersistenceFrame.this.solutionBusiness.solve(planningProblem);
                    }
                    catch (Throwable e) {
                        SolverAndPersistenceFrame.this.logger.error("Solving failed.", e);
                        bestSolution = null;
                    }
                    final Solution newSolution = bestSolution;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (newSolution != null) {
                                SolverAndPersistenceFrame.this.solutionBusiness.setSolution(newSolution);
                            }
                            SolverAndPersistenceFrame.this.setSolvingState(false);
                            SolverAndPersistenceFrame.this.resetScreen();
                        }
                    });
                }
            });
        }
    }

    private class LoadAction
    extends AbstractAction {
        private File file;

        public LoadAction(File file) {
            super("Load " + file.getName());
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.file);
                SolverAndPersistenceFrame.this.setSolutionLoaded();
            }
            finally {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

