/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class AbstractXmlSolutionImporter
extends AbstractSolutionImporter {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = ".xml";

    protected AbstractXmlSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract XmlInputBuilder createXmlInputBuilder();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Solution readSolution(File inputFile) {
        Solution solution;
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build((InputStream)in);
            XmlInputBuilder txtInputBuilder = this.createXmlInputBuilder();
            txtInputBuilder.setInputFile(inputFile);
            txtInputBuilder.setDocument(document);
            try {
                solution = txtInputBuilder.readSolution();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Exception in inputFile (" + inputFile + ")", e);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
                catch (JDOMException e2) {
                    throw new IllegalArgumentException("Could not parse the XML file (" + inputFile.getName() + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        this.logger.info("Imported: {}", (Object)inputFile);
        return solution;
    }

    public abstract class XmlInputBuilder {
        protected File inputFile;
        protected Document document;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setDocument(Document document) {
            this.document = document;
        }

        public abstract Solution readSolution() throws IOException, JDOMException;

        protected void assertElementName(Element element, String name) {
            if (!element.getName().equals(name)) {
                throw new IllegalStateException("Element name (" + element.getName() + ") should be " + name + ".");
            }
        }
    }
}

