/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractSolutionExporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractXmlSolutionExporter
extends AbstractSolutionExporter {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".xml";

    protected AbstractXmlSolutionExporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public abstract XmlOutputBuilder createXmlOutputBuilder();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeSolution(Solution solution, File outputFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            Document document = new Document();
            XmlOutputBuilder xmlOutputBuilder = this.createXmlOutputBuilder();
            xmlOutputBuilder.setDocument(document);
            xmlOutputBuilder.setSolution(solution);
            xmlOutputBuilder.writeSolution();
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(document, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not write the file (" + outputFile.getName() + ").", e);
                catch (JDOMException e2) {
                    throw new IllegalArgumentException("Could not format the XML file (" + outputFile.getName() + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        this.logger.info("Exported: {}", (Object)outputFile);
    }

    public abstract class XmlOutputBuilder {
        protected Document document;

        public void setDocument(Document document) {
            this.document = document;
        }

        public abstract void setSolution(Solution var1);

        public abstract void writeSolution() throws IOException, JDOMException;
    }
}

