/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.cloudbalancing.domain.CloudAssignment;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudAssignmentSwitchMove
implements Move,
TabuPropertyEnabled {
    private CloudAssignment leftCloudAssignment;
    private CloudAssignment rightCloudAssignment;

    public CloudAssignmentSwitchMove(CloudAssignment leftCloudAssignment, CloudAssignment rightCloudAssignment) {
        this.leftCloudAssignment = leftCloudAssignment;
        this.rightCloudAssignment = rightCloudAssignment;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftCloudAssignment.getCloudComputer(), (Object)this.rightCloudAssignment.getCloudComputer());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new CloudAssignmentSwitchMove(this.rightCloudAssignment, this.leftCloudAssignment);
    }

    public void doMove(WorkingMemory workingMemory) {
        CloudComputer oldLeftCloudComputer = this.leftCloudAssignment.getCloudComputer();
        CloudComputer oldRightCloudComputer = this.rightCloudAssignment.getCloudComputer();
        CloudBalancingMoveHelper.moveCloudComputer(workingMemory, this.leftCloudAssignment, oldRightCloudComputer);
        CloudBalancingMoveHelper.moveCloudComputer(workingMemory, this.rightCloudAssignment, oldLeftCloudComputer);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftCloudAssignment, this.rightCloudAssignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudAssignmentSwitchMove) {
            CloudAssignmentSwitchMove other = (CloudAssignmentSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftCloudAssignment, (Object)other.leftCloudAssignment).append((Object)this.rightCloudAssignment, (Object)other.rightCloudAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftCloudAssignment).append((Object)this.rightCloudAssignment).toHashCode();
    }

    public String toString() {
        return this.leftCloudAssignment + " <=> " + this.rightCloudAssignment;
    }
}

