/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.score.HardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.pas.domain.AdmissionPart;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.Department;
import org.drools.planner.examples.pas.domain.DepartmentSpecialism;
import org.drools.planner.examples.pas.domain.Equipment;
import org.drools.planner.examples.pas.domain.Night;
import org.drools.planner.examples.pas.domain.Patient;
import org.drools.planner.examples.pas.domain.PreferredPatientEquipment;
import org.drools.planner.examples.pas.domain.RequiredPatientEquipment;
import org.drools.planner.examples.pas.domain.Room;
import org.drools.planner.examples.pas.domain.RoomEquipment;
import org.drools.planner.examples.pas.domain.RoomSpecialism;
import org.drools.planner.examples.pas.domain.Specialism;
import org.drools.planner.examples.pas.domain.solver.AdmissionPartConflict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="PatientAdmissionSchedule")
public class PatientAdmissionSchedule
extends AbstractPersistable
implements Solution {
    private List<Specialism> specialismList;
    private List<Equipment> equipmentList;
    private List<Department> departmentList;
    private List<DepartmentSpecialism> departmentSpecialismList;
    private List<Room> roomList;
    private List<RoomSpecialism> roomSpecialismList;
    private List<RoomEquipment> roomEquipmentList;
    private List<Bed> bedList;
    private List<Night> nightList;
    private List<Patient> patientList;
    private List<AdmissionPart> admissionPartList;
    private List<RequiredPatientEquipment> requiredPatientEquipmentList;
    private List<PreferredPatientEquipment> preferredPatientEquipmentList;
    private List<BedDesignation> bedDesignationList;
    private HardAndSoftScore score;

    public List<Specialism> getSpecialismList() {
        return this.specialismList;
    }

    public void setSpecialismList(List<Specialism> specialismList) {
        this.specialismList = specialismList;
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<Equipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public List<Department> getDepartmentList() {
        return this.departmentList;
    }

    public void setDepartmentList(List<Department> departmentList) {
        this.departmentList = departmentList;
    }

    public List<DepartmentSpecialism> getDepartmentSpecialismList() {
        return this.departmentSpecialismList;
    }

    public void setDepartmentSpecialismList(List<DepartmentSpecialism> departmentSpecialismList) {
        this.departmentSpecialismList = departmentSpecialismList;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<RoomSpecialism> getRoomSpecialismList() {
        return this.roomSpecialismList;
    }

    public void setRoomSpecialismList(List<RoomSpecialism> roomSpecialismList) {
        this.roomSpecialismList = roomSpecialismList;
    }

    public List<RoomEquipment> getRoomEquipmentList() {
        return this.roomEquipmentList;
    }

    public void setRoomEquipmentList(List<RoomEquipment> roomEquipmentList) {
        this.roomEquipmentList = roomEquipmentList;
    }

    public List<Bed> getBedList() {
        return this.bedList;
    }

    public void setBedList(List<Bed> bedList) {
        this.bedList = bedList;
    }

    public List<Night> getNightList() {
        return this.nightList;
    }

    public void setNightList(List<Night> nightList) {
        this.nightList = nightList;
    }

    public List<Patient> getPatientList() {
        return this.patientList;
    }

    public void setPatientList(List<Patient> patientList) {
        this.patientList = patientList;
    }

    public List<AdmissionPart> getAdmissionPartList() {
        return this.admissionPartList;
    }

    public void setAdmissionPartList(List<AdmissionPart> admissionPartList) {
        this.admissionPartList = admissionPartList;
    }

    public List<RequiredPatientEquipment> getRequiredPatientEquipmentList() {
        return this.requiredPatientEquipmentList;
    }

    public void setRequiredPatientEquipmentList(List<RequiredPatientEquipment> requiredPatientEquipmentList) {
        this.requiredPatientEquipmentList = requiredPatientEquipmentList;
    }

    public List<PreferredPatientEquipment> getPreferredPatientEquipmentList() {
        return this.preferredPatientEquipmentList;
    }

    public void setPreferredPatientEquipmentList(List<PreferredPatientEquipment> preferredPatientEquipmentList) {
        this.preferredPatientEquipmentList = preferredPatientEquipmentList;
    }

    public List<BedDesignation> getBedDesignationList() {
        return this.bedDesignationList;
    }

    public void setBedDesignationList(List<BedDesignation> bedDesignationList) {
        this.bedDesignationList = bedDesignationList;
    }

    public HardAndSoftScore getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = (HardAndSoftScore)score;
    }

    public boolean isInitialized() {
        return this.bedDesignationList != null;
    }

    public Collection<? extends Object> getFacts() {
        ArrayList<Serializable> facts = new ArrayList<Serializable>();
        facts.addAll(this.specialismList);
        facts.addAll(this.equipmentList);
        facts.addAll(this.departmentList);
        facts.addAll(this.departmentSpecialismList);
        facts.addAll(this.roomList);
        facts.addAll(this.roomSpecialismList);
        facts.addAll(this.roomEquipmentList);
        facts.addAll(this.bedList);
        facts.addAll(this.nightList);
        facts.addAll(this.patientList);
        facts.addAll(this.admissionPartList);
        facts.addAll(this.requiredPatientEquipmentList);
        facts.addAll(this.preferredPatientEquipmentList);
        if (this.isInitialized()) {
            facts.addAll(this.bedDesignationList);
        }
        facts.addAll(this.calculateAdmissionPartConflictList());
        return facts;
    }

    private List<AdmissionPartConflict> calculateAdmissionPartConflictList() {
        ArrayList<AdmissionPartConflict> admissionPartConflictList = new ArrayList<AdmissionPartConflict>();
        for (AdmissionPart leftAdmissionPart : this.admissionPartList) {
            for (AdmissionPart rightAdmissionPart : this.admissionPartList) {
                int sameNightCount;
                if (leftAdmissionPart.getId() >= rightAdmissionPart.getId() || (sameNightCount = leftAdmissionPart.calculateSameNightCount(rightAdmissionPart)) <= 0) continue;
                admissionPartConflictList.add(new AdmissionPartConflict(leftAdmissionPart, rightAdmissionPart, sameNightCount));
            }
        }
        return admissionPartConflictList;
    }

    public PatientAdmissionSchedule cloneSolution() {
        PatientAdmissionSchedule clone = new PatientAdmissionSchedule();
        clone.id = this.id;
        clone.specialismList = this.specialismList;
        clone.equipmentList = this.equipmentList;
        clone.departmentList = this.departmentList;
        clone.departmentSpecialismList = this.departmentSpecialismList;
        clone.roomList = this.roomList;
        clone.roomSpecialismList = this.roomSpecialismList;
        clone.roomEquipmentList = this.roomEquipmentList;
        clone.bedList = this.bedList;
        clone.nightList = this.nightList;
        clone.patientList = this.patientList;
        clone.admissionPartList = this.admissionPartList;
        clone.requiredPatientEquipmentList = this.requiredPatientEquipmentList;
        clone.preferredPatientEquipmentList = this.preferredPatientEquipmentList;
        ArrayList<BedDesignation> clonedBedDesignationList = new ArrayList<BedDesignation>(this.bedDesignationList.size());
        for (BedDesignation bedDesignation : this.bedDesignationList) {
            BedDesignation clonedBedDesignation = bedDesignation.clone();
            clonedBedDesignationList.add(clonedBedDesignation);
        }
        clone.bedDesignationList = clonedBedDesignationList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof PatientAdmissionSchedule)) {
            return false;
        }
        PatientAdmissionSchedule other = (PatientAdmissionSchedule)o;
        if (this.bedDesignationList.size() != other.bedDesignationList.size()) {
            return false;
        }
        Iterator<BedDesignation> it = this.bedDesignationList.iterator();
        Iterator<BedDesignation> otherIt = other.bedDesignationList.iterator();
        while (it.hasNext()) {
            BedDesignation otherBedDesignation;
            BedDesignation bedDesignation = it.next();
            if (bedDesignation.solutionEquals(otherBedDesignation = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (BedDesignation bedDesignation : this.bedDesignationList) {
            hashCodeBuilder.append(bedDesignation.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

