/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.persistence;

import java.io.IOException;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractXmlSolutionExporter;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.persistence.NurseRosteringDaoImpl;
import org.jdom.Content;
import org.jdom.Element;

public class NurseRosteringSolutionExporter
extends AbstractXmlSolutionExporter {
    public static void main(String[] args) {
        new NurseRosteringSolutionExporter().convertAll();
    }

    public NurseRosteringSolutionExporter() {
        super(new NurseRosteringDaoImpl());
    }

    public AbstractXmlSolutionExporter.XmlOutputBuilder createXmlOutputBuilder() {
        return new NurseRosteringOutputBuilder();
    }

    public class NurseRosteringOutputBuilder
    extends AbstractXmlSolutionExporter.XmlOutputBuilder {
        private NurseRoster nurseRoster;

        public void setSolution(Solution solution) {
            this.nurseRoster = (NurseRoster)solution;
        }

        public void writeSolution() throws IOException {
            Element solutionElement = new Element("Solution");
            this.document.setRootElement(solutionElement);
            Element schedulingPeriodIDElement = new Element("SchedulingPeriodID");
            schedulingPeriodIDElement.setText(this.nurseRoster.getCode());
            solutionElement.addContent((Content)schedulingPeriodIDElement);
            Element competitorElement = new Element("Competitor");
            competitorElement.setText("Geoffrey De Smet with Drools Planner");
            solutionElement.addContent((Content)competitorElement);
            Element softConstraintsPenaltyElement = new Element("SoftConstraintsPenalty");
            softConstraintsPenaltyElement.setText(Integer.toString(this.nurseRoster.getScore().getSoftScore()));
            solutionElement.addContent((Content)softConstraintsPenaltyElement);
            for (Assignment assignment : this.nurseRoster.getAssignmentList()) {
                Shift shift = assignment.getShift();
                if (shift == null) continue;
                Element assignmentElement = new Element("Assignment");
                solutionElement.addContent((Content)assignmentElement);
                Element dateElement = new Element("Date");
                dateElement.setText(shift.getShiftDate().getDateString());
                assignmentElement.addContent((Content)dateElement);
                Element employeeElement = new Element("Employee");
                employeeElement.setText(assignment.getEmployee().getCode());
                assignmentElement.addContent((Content)employeeElement);
                Element shiftTypeElement = new Element("ShiftType");
                shiftTypeElement.setText(shift.getShiftType().getCode());
                assignmentElement.addContent((Content)shiftTypeElement);
            }
        }
    }
}

