/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.nqueens.domain.Queen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YChangeMove
implements Move,
TabuPropertyEnabled {
    private Queen queen;
    private int toY;

    public YChangeMove(Queen queen, int toY) {
        this.queen = queen;
        this.toY = toY;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return this.queen.getY() != this.toY;
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new YChangeMove(this.queen, this.queen.getY());
    }

    public void doMove(WorkingMemory workingMemory) {
        FactHandle queenHandle = workingMemory.getFactHandle((Object)this.queen);
        this.queen.setY(this.toY);
        workingMemory.update((org.drools.runtime.rule.FactHandle)queenHandle, (Object)this.queen);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.queen);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof YChangeMove) {
            YChangeMove other = (YChangeMove)o;
            return new EqualsBuilder().append((Object)this.queen, (Object)other.queen).append(this.toY, other.toY).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.queen).append(this.toY).toHashCode();
    }

    public String toString() {
        return this.queen + " => " + this.toY;
    }
}

