/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.score.DefaultHardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.initializer.AbstractStartingSolutionInitializer;
import org.drools.planner.core.solver.AbstractSolverScope;
import org.drools.planner.examples.cloudbalancing.domain.CloudAssignment;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.PersistableIdComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudBalancingStartingSolutionInitializer
extends AbstractStartingSolutionInitializer {
    public boolean isSolutionInitialized(AbstractSolverScope abstractSolverScope) {
        CloudBalance cloudBalance = (CloudBalance)abstractSolverScope.getWorkingSolution();
        return cloudBalance.isInitialized();
    }

    public void initializeSolution(AbstractSolverScope abstractSolverScope) {
        CloudBalance cloudBalance = (CloudBalance)abstractSolverScope.getWorkingSolution();
        this.initializeCloudAssignmentList(abstractSolverScope, cloudBalance);
    }

    private void initializeCloudAssignmentList(AbstractSolverScope abstractSolverScope, CloudBalance cloudBalance) {
        List<CloudComputer> cloudComputerList = cloudBalance.getCloudComputerList();
        WorkingMemory workingMemory = abstractSolverScope.getWorkingMemory();
        List<CloudAssignment> cloudAssignmentList = this.createCloudAssignmentList(cloudBalance);
        for (CloudAssignment cloudAssignment : cloudAssignmentList) {
            FactHandle cloudAssignmentHandle = null;
            DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
            CloudComputer bestCloudComputer = null;
            for (CloudComputer cloudComputer : cloudComputerList) {
                Score score;
                if (cloudAssignmentHandle == null) {
                    cloudAssignment.setCloudComputer(cloudComputer);
                    cloudAssignmentHandle = workingMemory.insert((Object)cloudAssignment);
                } else {
                    cloudAssignment.setCloudComputer(cloudComputer);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)cloudAssignmentHandle, (Object)cloudAssignment);
                }
                if ((score = abstractSolverScope.calculateScoreFromWorkingMemory()).compareTo((Object)bestScore) <= 0) continue;
                bestScore = score;
                bestCloudComputer = cloudComputer;
            }
            if (bestCloudComputer == null || bestCloudComputer == null) {
                throw new IllegalStateException("The bestCloudComputer (" + bestCloudComputer + ") cannot be null.");
            }
            cloudAssignment.setCloudComputer(bestCloudComputer);
            workingMemory.update(cloudAssignmentHandle, (Object)cloudAssignment);
            this.logger.debug("    CloudAssignment ({}) initialized for starting solution.", (Object)cloudAssignment);
        }
        Collections.sort(cloudAssignmentList, new PersistableIdComparator());
        cloudBalance.setCloudAssignmentList(cloudAssignmentList);
    }

    public List<CloudAssignment> createCloudAssignmentList(CloudBalance cloudBalance) {
        List<CloudProcess> cloudProcessList = cloudBalance.getCloudProcessList();
        ArrayList<CloudProcessInitializationWeight> cloudProcessInitializationWeightList = new ArrayList<CloudProcessInitializationWeight>(cloudProcessList.size());
        for (CloudProcess cloudProcess : cloudProcessList) {
            cloudProcessInitializationWeightList.add(new CloudProcessInitializationWeight(cloudBalance, cloudProcess));
        }
        Collections.sort(cloudProcessInitializationWeightList);
        ArrayList<CloudAssignment> cloudAssignmentList = new ArrayList<CloudAssignment>(cloudProcessList.size());
        int cloudAssignmentId = 0;
        for (CloudProcessInitializationWeight cloudProcessInitializationWeight : cloudProcessInitializationWeightList) {
            CloudProcess cloudProcess = cloudProcessInitializationWeight.getCloudProcess();
            CloudAssignment cloudAssignment = new CloudAssignment();
            cloudAssignment.setId(Long.valueOf(cloudAssignmentId));
            cloudAssignment.setCloudProcess(cloudProcess);
            cloudAssignmentList.add(cloudAssignment);
            ++cloudAssignmentId;
        }
        Collections.sort(cloudAssignmentList);
        return cloudAssignmentList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloudProcessInitializationWeight
    implements Comparable<CloudProcessInitializationWeight> {
        private CloudProcess cloudProcess;

        private CloudProcessInitializationWeight(CloudBalance cloudBalance, CloudProcess cloudProcess) {
            this.cloudProcess = cloudProcess;
        }

        public CloudProcess getCloudProcess() {
            return this.cloudProcess;
        }

        @Override
        public int compareTo(CloudProcessInitializationWeight other) {
            return new CompareToBuilder().append(other.cloudProcess.getMinimalMultiplicand(), this.cloudProcess.getMinimalMultiplicand()).toComparison();
        }
    }
}

