/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.score.HardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.cloudbalancing.domain.CloudAssignment;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.AbstractPersistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="CloudBalance")
public class CloudBalance
extends AbstractPersistable
implements Solution {
    private List<CloudComputer> cloudComputerList;
    private List<CloudProcess> cloudProcessList;
    private List<CloudAssignment> cloudAssignmentList;
    private HardAndSoftScore score;

    public List<CloudComputer> getCloudComputerList() {
        return this.cloudComputerList;
    }

    public void setCloudComputerList(List<CloudComputer> cloudComputerList) {
        this.cloudComputerList = cloudComputerList;
    }

    public List<CloudProcess> getCloudProcessList() {
        return this.cloudProcessList;
    }

    public void setCloudProcessList(List<CloudProcess> cloudProcessList) {
        this.cloudProcessList = cloudProcessList;
    }

    public List<CloudAssignment> getCloudAssignmentList() {
        return this.cloudAssignmentList;
    }

    public void setCloudAssignmentList(List<CloudAssignment> cloudAssignmentList) {
        this.cloudAssignmentList = cloudAssignmentList;
    }

    public HardAndSoftScore getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = (HardAndSoftScore)score;
    }

    public boolean isInitialized() {
        return this.cloudAssignmentList != null;
    }

    public Collection<? extends Object> getFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.cloudComputerList);
        facts.addAll(this.cloudProcessList);
        if (this.isInitialized()) {
            facts.addAll(this.cloudAssignmentList);
        }
        return facts;
    }

    public CloudBalance cloneSolution() {
        CloudBalance clone = new CloudBalance();
        clone.id = this.id;
        clone.cloudComputerList = this.cloudComputerList;
        clone.cloudProcessList = this.cloudProcessList;
        ArrayList<CloudAssignment> clonedCloudAssignmentList = new ArrayList<CloudAssignment>(this.cloudAssignmentList.size());
        for (CloudAssignment cloudAssignment : this.cloudAssignmentList) {
            CloudAssignment clonedCloudAssignment = cloudAssignment.clone();
            clonedCloudAssignmentList.add(clonedCloudAssignment);
        }
        clone.cloudAssignmentList = clonedCloudAssignmentList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CloudBalance)) {
            return false;
        }
        CloudBalance other = (CloudBalance)o;
        if (this.cloudAssignmentList.size() != other.cloudAssignmentList.size()) {
            return false;
        }
        Iterator<CloudAssignment> it = this.cloudAssignmentList.iterator();
        Iterator<CloudAssignment> otherIt = other.cloudAssignmentList.iterator();
        while (it.hasNext()) {
            CloudAssignment otherCloudAssignment;
            CloudAssignment cloudAssignment = it.next();
            if (cloudAssignment.solutionEquals(otherCloudAssignment = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CloudAssignment cloudAssignment : this.cloudAssignmentList) {
            hashCodeBuilder.append(cloudAssignment.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

