/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NativeFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XstreamSolutionDaoImpl
implements SolutionDao {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private XStream xStream;
    private String dirName;
    private File dataDir;

    public XstreamSolutionDaoImpl(String dirName, Class ... xstreamAnnotations) {
        this.dirName = dirName;
        this.dataDir = new File("data/" + dirName);
        this.xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new NativeFieldKeySorter())));
        this.xStream.setMode(1002);
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public String getDirName() {
        return this.dirName;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public Solution readSolution(File file) {
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            Solution solution = (Solution)this.xStream.fromXML(reader);
            this.logger.info("Loaded: {}", (Object)file);
            Solution solution2 = solution;
            return solution2;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file: " + file, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Problem closing file (" + file + ")", (Throwable)e);
                }
            }
        }
    }

    public Solution readSolution(InputStream in) {
        InputStreamReader reader = null;
        try {
            Solution solution;
            reader = new InputStreamReader(in, "UTF-8");
            Solution solution2 = solution = (Solution)this.xStream.fromXML((Reader)reader);
            return solution2;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read from InputStream: " + in, e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    this.logger.warn("Problem closing InputStream (" + in + ")", (Throwable)e);
                }
            }
        }
    }

    public void writeSolution(Solution solution, File file) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            this.xStream.toXML((Object)solution, writer);
            this.logger.info("Saved: {}", (Object)file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write file (" + file + ")", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.warn("Problem closing file (" + file + ")", (Throwable)e);
                }
            }
        }
    }
}

