/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.domain.Team;
import org.drools.planner.examples.travelingtournament.domain.TravelingTournament;

public abstract class TravelingTournamentSolutionImporter
extends AbstractTxtSolutionImporter {
    protected TravelingTournamentSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class TravelingTournamentInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        @Override
        public Solution readSolution() throws IOException {
            TravelingTournament travelingTournament = new TravelingTournament();
            travelingTournament.setId(0L);
            int n = this.readN();
            List<Team> teamList = this.readTeamList(n);
            travelingTournament.setTeamList(teamList);
            List<Day> dayList = this.constructDayList(n);
            travelingTournament.setDayList(dayList);
            List<List<Integer>> outerDistanceList = this.readOuterDistanceList();
            List<Match> matchList = this.constructMatchListAndSetDistancesInTeamList(teamList, outerDistanceList);
            travelingTournament.setMatchList(matchList);
            this.initializeMatchDays(travelingTournament);
            return travelingTournament;
        }

        private int readN() throws IOException {
            return Integer.parseInt(this.bufferedReader.readLine());
        }

        private List<Team> readTeamList(int n) throws IOException {
            ArrayList<Team> teamList = new ArrayList<Team>();
            for (int i = 0; i < n; ++i) {
                Team team = new Team();
                team.setId(Long.valueOf(i));
                team.setName(this.bufferedReader.readLine());
                team.setDistanceToTeamMap(new HashMap<Team, Integer>());
                teamList.add(team);
            }
            return teamList;
        }

        private List<List<Integer>> readOuterDistanceList() throws IOException {
            ArrayList<List<Integer>> outerDistanceList = new ArrayList<List<Integer>>();
            String line = this.bufferedReader.readLine();
            while (line != null && !line.replaceAll("\\s+", "").equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(line.replaceAll("\\s+", " ").trim());
                ArrayList<Integer> innerDistanceList = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    int distance = Integer.parseInt(tokenizer.nextToken());
                    innerDistanceList.add(distance);
                }
                outerDistanceList.add(innerDistanceList);
                line = this.bufferedReader.readLine();
            }
            return outerDistanceList;
        }

        private List<Day> constructDayList(int n) {
            ArrayList<Day> dayList = new ArrayList<Day>();
            int daySize = (n - 1) * 2;
            for (int i = 0; i < daySize; ++i) {
                Day day = new Day();
                day.setId(Long.valueOf(i));
                day.setIndex(i);
                dayList.add(day);
            }
            return dayList;
        }

        private List<Match> constructMatchListAndSetDistancesInTeamList(List<Team> teamList, List<List<Integer>> outerDistanceList) {
            ArrayList<Match> matchList = new ArrayList<Match>();
            int i = 0;
            long matchId = 0L;
            for (Team homeTeam : teamList) {
                int j = 0;
                for (Team awayTeam : teamList) {
                    int distance = outerDistanceList.get(i).get(j);
                    homeTeam.getDistanceToTeamMap().put(awayTeam, distance);
                    if (i != j) {
                        Match match = new Match();
                        match.setId(matchId);
                        ++matchId;
                        match.setHomeTeam(homeTeam);
                        match.setAwayTeam(awayTeam);
                        matchList.add(match);
                    }
                    ++j;
                }
                ++i;
            }
            return matchList;
        }

        protected abstract void initializeMatchDays(TravelingTournament var1);
    }
}

