/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.pas.domain.AdmissionPart;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.Department;
import org.drools.planner.examples.pas.domain.Gender;
import org.drools.planner.examples.pas.domain.GenderLimitation;
import org.drools.planner.examples.pas.domain.Patient;
import org.drools.planner.examples.pas.domain.Room;
import org.drools.planner.examples.pas.domain.Specialism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="BedDesignation")
public class BedDesignation
extends AbstractPersistable
implements Comparable<BedDesignation> {
    private AdmissionPart admissionPart;
    private Bed bed;

    public AdmissionPart getAdmissionPart() {
        return this.admissionPart;
    }

    public void setAdmissionPart(AdmissionPart admissionPart) {
        this.admissionPart = admissionPart;
    }

    public Bed getBed() {
        return this.bed;
    }

    public void setBed(Bed bed) {
        this.bed = bed;
    }

    @Override
    public int compareTo(BedDesignation other) {
        return new CompareToBuilder().append((Object)this.admissionPart, (Object)other.admissionPart).append((Object)this.bed, (Object)other.bed).append((Object)this.id, (Object)other.id).toComparison();
    }

    public BedDesignation clone() {
        BedDesignation clone = new BedDesignation();
        clone.id = this.id;
        clone.admissionPart = this.admissionPart;
        clone.bed = this.bed;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignation) {
            BedDesignation other = (BedDesignation)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.admissionPart, (Object)other.admissionPart).append((Object)this.bed, (Object)other.bed).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.bed).toHashCode();
    }

    @Override
    public String toString() {
        return this.admissionPart + " @ " + this.bed;
    }

    public Patient getPatient() {
        return this.admissionPart.getPatient();
    }

    public Gender getPatientGender() {
        return this.admissionPart.getPatient().getGender();
    }

    public int getPatientAge() {
        return this.admissionPart.getPatient().getAge();
    }

    public int getPatientPreferredMaximumRoomCapacity() {
        return this.admissionPart.getPatient().getPreferredMaximumRoomCapacity();
    }

    public Specialism getAdmissionPartSpecialism() {
        return this.admissionPart.getSpecialism();
    }

    public int getAdmissionPartNightCount() {
        return this.admissionPart.getNightCount();
    }

    public Room getRoom() {
        return this.bed.getRoom();
    }

    public int getRoomCapacity() {
        return this.bed.getRoom().getCapacity();
    }

    public Department getDepartment() {
        return this.bed.getRoom().getDepartment();
    }

    public GenderLimitation getRoomGenderLimitation() {
        return this.bed.getRoom().getGenderLimitation();
    }
}

