/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.flow.bpmn2.editor.BPMNModelEditor;
import org.drools.eclipse.flow.ruleflow.core.RuleSetNodeWrapper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.jbpm.workflow.core.node.RuleSetNode;

public class RuleFlowGroupHyperlink
implements IHyperlink {
    AttributeDescr descr;
    ProcessInfo processInfo;
    List<RuleSetNode> nodes;

    public RuleFlowGroupHyperlink(AttributeDescr descr, ProcessInfo processInfo, List<RuleSetNode> nodes) {
        this.descr = descr;
        this.processInfo = processInfo;
        this.nodes = nodes;
    }

    public IRegion getHyperlinkRegion() {
        return new Region(this.descr.getStartCharacter(), this.descr.getEndCharacter() - this.descr.getStartCharacter());
    }

    public String getTypeLabel() {
        return "drools-" + this.descr.getType();
    }

    public String getHyperlinkText() {
        return "Open " + this.processInfo.getProcessId();
    }

    public void open() {
        IResource resource = DroolsEclipsePlugin.getDefault().findProcessResource(this.processInfo.getProcessId());
        if (resource != null) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource));
                if (editor instanceof FormEditor) {
                    editor = ((FormEditor)editor).getActiveEditor();
                }
                if (editor instanceof BPMNModelEditor) {
                    EditPart editPart = (EditPart)editor.getAdapter(EditPart.class);
                    ArrayList<EditPart> selectedParts = new ArrayList<EditPart>();
                    for (RuleSetNode node : this.nodes) {
                        EditPart part = this.findEditPart(editPart, node);
                        if (part == null) continue;
                        selectedParts.add(part);
                    }
                    if (selectedParts.size() > 0) {
                        ((BPMNModelEditor)editor).getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(selectedParts));
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
    }

    private EditPart findEditPart(EditPart root, RuleSetNode node) {
        for (Object element : root.getChildren()) {
            if (((EditPart)element).getModel() instanceof RuleSetNodeWrapper) {
                if (node.getId() != ((RuleSetNodeWrapper)((EditPart)element).getModel()).getNode().getId()) continue;
                return (EditPart)element;
            }
            EditPart result = this.findEditPart((EditPart)element, node);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

