/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.core.ruleunit.RuleUnitRegistry;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMML4Data;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.pmml_4_2.model.AbstractPMMLData;
import org.kie.pmml.pmml_4_2.model.PMML4UnitImpl;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecution;

public class PMML4ExecutionHelper {
    private KieBase kbase;
    private String modelName;
    private List<String> possiblePackageNames;
    private RuleUnitExecutor executor;
    private Class<? extends RuleUnit> ruleUnitClass;
    private DataSource<PMMLRequestData> requestData;
    private DataSource<PMML4Result> resultData;
    private DataSource<PMML4Data> pmmlData;
    private DataSource<SegmentExecution> childModelSegments;
    private DataSource<? extends AbstractPMMLData> miningModelPojo;
    private PMML4Result baseResultHolder;
    private boolean includeMiningDataSources;
    private boolean used;

    private PMML4ExecutionHelper(String modelName, KieBase kbase, boolean includeMiningDataSources) {
        this.kbase = kbase;
        this.initExecutionHelper(modelName, includeMiningDataSources);
    }

    private PMML4ExecutionHelper(String modelName, String classpathName, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
        this.kbase = new KieHelper().addFromClassPath(classpathName).build(kieBaseConf);
        this.initExecutionHelper(modelName, includeMiningDataSources);
    }

    private PMML4ExecutionHelper(String modelName, byte[] content, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
        this.kbase = new KieHelper().addContent(new String(content), ResourceType.PMML).build(kieBaseConf);
        this.initExecutionHelper(modelName, includeMiningDataSources);
    }

    private PMML4ExecutionHelper(String modelName, Resource resource, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
        this.kbase = new KieHelper().addResource(resource, ResourceType.PMML).build(kieBaseConf);
        this.initExecutionHelper(modelName, includeMiningDataSources);
    }

    private void initExecutionHelper(String modelName, boolean includeMiningDataSources) {
        this.modelName = modelName;
        this.possiblePackageNames = new ArrayList<String>();
        this.includeMiningDataSources = includeMiningDataSources;
        this.initRuleUnitExecutor();
    }

    protected void initRuleUnitExecutor() throws IllegalStateException {
        if (this.kbase == null) {
            throw new IllegalStateException("Unable to create executor: KieBase is null or invalid");
        }
        if (this.used) {
            throw new IllegalStateException("Executor cannot be reinitalized if it has been used");
        }
        if (this.executor != null) {
            this.executor.dispose();
        }
        this.executor = RuleUnitExecutor.create().bind(this.kbase);
        this.requestData = this.executor.newDataSource("request", (Object[])new PMMLRequestData[0]);
        this.resultData = this.executor.newDataSource("results", (Object[])new PMML4Result[0]);
        this.pmmlData = this.executor.newDataSource("pmmlData", (Object[])new PMML4Data[0]);
        String startingRuleName = "RuleUnitIndicator";
        if (this.includeMiningDataSources) {
            this.childModelSegments = this.executor.newDataSource("childModelSegments", (Object[])new SegmentExecution[0]);
            this.miningModelPojo = this.executor.newDataSource("miningModelPojo", (Object[])new AbstractPMMLData[0]);
            startingRuleName = "Start Mining - " + this.modelName;
        }
        this.ruleUnitClass = this.getStartingRuleUnit(startingRuleName);
    }

    public RuleUnitExecutor getExecutor() {
        return this.executor;
    }

    public KieBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KieBase kbase) {
        this.kbase = kbase;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    protected List<String> getPossiblePackageNames() {
        return new ArrayList<String>(this.possiblePackageNames);
    }

    public boolean addPossiblePackageName(String packageName) {
        boolean retval = this.possiblePackageNames.add(packageName);
        this.initRuleUnitExecutor();
        return retval;
    }

    public void setPossiblePackageNames(List<String> possiblePackageNames) {
        this.possiblePackageNames = possiblePackageNames;
        this.initRuleUnitExecutor();
    }

    public Class<? extends RuleUnit> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public void setRuleUnitClass(Class<? extends RuleUnit> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
    }

    public DataSource<PMMLRequestData> getRequestData() {
        return this.requestData;
    }

    public DataSource<PMML4Result> getResultData() {
        return this.resultData;
    }

    public DataSource<PMML4Data> getPmmlData() {
        return this.pmmlData;
    }

    public DataSource<SegmentExecution> getChildModelSegments() {
        return this.childModelSegments;
    }

    public DataSource<? extends AbstractPMMLData> getMiningModelPojo() {
        return this.miningModelPojo;
    }

    public PMML4Result getBaseResultHolder() {
        return this.baseResultHolder;
    }

    public boolean isIncludeMiningDataSources() {
        return this.includeMiningDataSources;
    }

    public void setIncludeMiningDataSources(boolean includeMiningDataSources) {
        this.includeMiningDataSources = includeMiningDataSources;
        this.initRuleUnitExecutor();
    }

    public synchronized PMML4Result submitRequest(PMMLRequestData request) throws InvalidParameterException, IllegalStateException {
        if (request == null) {
            throw new InvalidParameterException("PMML model cannot be applied to a null request");
        }
        if (this.ruleUnitClass == null) {
            throw new IllegalStateException("PMML model cannot be applied. Missing ruleUnitClass.");
        }
        if (this.used) {
            this.used = false;
            this.initRuleUnitExecutor();
        }
        this.requestData.insert((Object)request);
        this.baseResultHolder = new PMML4Result(request.getCorrelationId());
        this.resultData.insert((Object)this.baseResultHolder);
        this.executor.run(this.ruleUnitClass);
        this.used = true;
        return this.baseResultHolder;
    }

    protected Class<? extends RuleUnit> getStartingRuleUnit(String startingRule) throws IllegalStateException {
        if (this.kbase == null) {
            throw new IllegalStateException("Cannot determine starting rule unit. KieBase is null");
        }
        InternalKnowledgeBase ikb = (InternalKnowledgeBase)this.kbase;
        RuleUnitRegistry unitRegistry = ikb.getRuleUnitRegistry();
        Map pkgs = ikb.getPackagesMap();
        for (String pkgName : this.calculatePossiblePackageNames()) {
            RuleUnitDescr descr;
            InternalKnowledgePackage pkg;
            RuleImpl ruleImpl;
            if (!pkgs.containsKey(pkgName) || (ruleImpl = (pkg = (InternalKnowledgePackage)pkgs.get(pkgName)).getRule(startingRule)) == null || (descr = (RuleUnitDescr)unitRegistry.getRuleUnitFor(ruleImpl).orElse(null)) == null) continue;
            return descr.getRuleUnitClass();
        }
        return null;
    }

    protected List<String> calculatePossiblePackageNames() {
        return this.calculatePossiblePackageNames(this.modelName, this.possiblePackageNames.toArray(new String[0]));
    }

    protected List<String> calculatePossiblePackageNames(String modelId, String ... knownPackageNames) {
        ArrayList<String> packageNames = new ArrayList<String>();
        String javaModelId = modelId.replaceAll("\\s", "");
        if (knownPackageNames != null && knownPackageNames.length > 0) {
            for (String knownPkgName : knownPackageNames) {
                packageNames.add(knownPkgName + "." + javaModelId);
            }
        }
        packageNames.add(PMML4UnitImpl.DEFAULT_ROOT_PACKAGE + "." + javaModelId);
        return packageNames;
    }

    public static class PMML4ExecutionHelperFactory {
        public static PMML4ExecutionHelper getExecutionHelper(String modelName, KieBase kbase) {
            return new PMML4ExecutionHelper(modelName, kbase, false);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, KieBase kbase, boolean includeMiningDataSources) {
            return new PMML4ExecutionHelper(modelName, kbase, includeMiningDataSources);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, String classPath, KieBaseConfiguration kieBaseConf) {
            return new PMML4ExecutionHelper(modelName, classPath, kieBaseConf, false);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, String classPath, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
            return new PMML4ExecutionHelper(modelName, classPath, kieBaseConf, includeMiningDataSources);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, byte[] content, KieBaseConfiguration kieBaseConf) {
            return new PMML4ExecutionHelper(modelName, content, kieBaseConf, false);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, byte[] content, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
            return new PMML4ExecutionHelper(modelName, content, kieBaseConf, includeMiningDataSources);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, Resource resource, KieBaseConfiguration kieBaseConf) {
            return new PMML4ExecutionHelper(modelName, resource, kieBaseConf, false);
        }

        public static PMML4ExecutionHelper getExecutionHelper(String modelName, Resource resource, KieBaseConfiguration kieBaseConf, boolean includeMiningDataSources) {
            return new PMML4ExecutionHelper(modelName, resource, kieBaseConf, includeMiningDataSources);
        }
    }
}

