/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.scorecard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kie.dmg.pmml.pmml_4_2.descr.Apply;
import org.kie.dmg.pmml.pmml_4_2.descr.Attribute;
import org.kie.dmg.pmml.pmml_4_2.descr.Characteristic;
import org.kie.dmg.pmml.pmml_4_2.descr.ComplexPartialScore;
import org.kie.dmg.pmml.pmml_4_2.descr.FieldRef;
import org.kie.pmml.pmml_4_2.PMML4Helper;

public class ComplexScore {
    private static PMML4Helper helper = new PMML4Helper();
    private String complexScore;
    private String characteristicName;
    private int attributeIndex;
    private List<String> fldNames;

    public ComplexScore(Characteristic charac, Attribute attrib) {
        this.characteristicName = charac.getName();
        this.attributeIndex = charac.getAttributes().indexOf(attrib);
        this.complexScore = helper.createPartialScoreFormula(attrib);
        this.fldNames = new ArrayList<String>();
        this.createListOfFieldNames(attrib);
    }

    private void createListOfFieldNames(Attribute attrib) {
        ComplexPartialScore cps = attrib.getComplexPartialScore();
        if (cps != null) {
            if (cps.getApply() != null) {
                this.iterateThroughComplexPartialScoreElements(cps.getApply());
            } else if (cps.getFieldRef() != null) {
                this.fldNames.add(cps.getFieldRef().getField());
            }
        }
    }

    private void iterateThroughComplexPartialScoreElements(Serializable sz) {
        if (sz instanceof Apply) {
            Apply inner = (Apply)sz;
            inner.getConstantsAndFieldRevesAndNormContinuouses().forEach(s -> this.iterateThroughComplexPartialScoreElements((Serializable)s));
        } else if (sz instanceof FieldRef) {
            this.fldNames.add(((FieldRef)sz).getField());
        }
    }

    public String getComplexScore() {
        return this.complexScore;
    }

    public String getCharacteristicName() {
        return this.characteristicName;
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    public List<String> getFldNames() {
        return new ArrayList<String>(this.fldNames);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attributeIndex;
        result = 31 * result + (this.characteristicName == null ? 0 : this.characteristicName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexScore other = (ComplexScore)obj;
        if (this.attributeIndex != other.attributeIndex) {
            return false;
        }
        return !(this.characteristicName == null ? other.characteristicName != null : !this.characteristicName.equals(other.characteristicName));
    }

    public String toString() {
        return "ComplexScore [complexScore=" + this.complexScore + ", characteristicName=" + this.characteristicName + ", attributeIndex=" + this.attributeIndex + ", fldNames=" + this.fldNames + "]";
    }
}

