/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.pmml_4_2.descr.DataDictionary;
import org.dmg.pmml.pmml_4_2.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_2.descr.MININGFUNCTION;
import org.dmg.pmml.pmml_4_2.descr.MiningModel;
import org.dmg.pmml.pmml_4_2.descr.MiningSchema;
import org.dmg.pmml.pmml_4_2.descr.Output;
import org.dmg.pmml.pmml_4_2.descr.Scorecard;
import org.dmg.pmml.pmml_4_2.descr.Segmentation;
import org.kie.pmml.pmml_4_2.PMML4Model;
import org.kie.pmml.pmml_4_2.PMML4Unit;
import org.kie.pmml.pmml_4_2.model.AbstractModel;
import org.kie.pmml.pmml_4_2.model.PMML4ModelType;
import org.kie.pmml.pmml_4_2.model.PMMLMiningField;
import org.kie.pmml.pmml_4_2.model.PMMLOutputField;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegment;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegmentation;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;

public class Miningmodel
extends AbstractModel<MiningModel> {
    private static String MINING_POJO_TEMPLATE = "/org/kie/pmml/pmml_4_2/templates/mvel/mining/miningMiningPojo.mvel";
    private static String OUTPUT_POJO_TEMPLATE = "/org/kie/pmml/pmml_4_2/templates/mvel/mining/miningOutputPojo.mvel";
    private static String RULE_UNIT_TEMPLATE = "/org/kie/pmml/pmml_4_2/templates/mvel/mining/miningRuleUnit.mvel";
    private Map<String, PMML4Model> childModels;
    private MiningSegmentation segmentation;
    private MININGFUNCTION functionName;
    private String algorithmName;
    private boolean scoreable;

    public Miningmodel(String modelId, MiningModel model, PMML4Model parentModel, PMML4Unit owner) {
        super(modelId, PMML4ModelType.MINING, owner, parentModel, model);
        this.scoreable = model.getIsScorable();
        this.initChildModels();
    }

    @Override
    public Map<String, PMML4Model> getChildModels() {
        return this.childModels != null && !this.childModels.isEmpty() ? new HashMap<String, PMML4Model>(this.childModels) : new HashMap<String, PMML4Model>();
    }

    protected void initChildModels() {
        this.childModels = new HashMap<String, PMML4Model>();
        Iterator<Serializable> extenIter = ((MiningModel)this.rawModel).getExtensionsAndMiningSchemasAndOutputs().iterator();
        this.segmentation = null;
        while (extenIter.hasNext() && this.segmentation == null) {
            Serializable obj = extenIter.next();
            if (!(obj instanceof Segmentation)) continue;
            this.segmentation = new MiningSegmentation(this, (Segmentation)obj);
        }
        if (this.segmentation != null) {
            List<MiningSegment> segments = this.segmentation.getMiningSegments();
            DataDictionary dd = this.getDataDictionary();
            for (MiningSegment seg : this.segmentation.getMiningSegments()) {
                this.childModels.put(seg.getModel().getModelId(), seg.getModel());
            }
        }
    }

    private PMMLOutputField getChildOutputField(PMML4Model parentModel, String fieldName) {
        PMMLOutputField output = null;
        Iterator<PMML4Model> childIter = parentModel.getChildModels().values().iterator();
        while (childIter.hasNext() && output == null) {
            PMML4Model child = childIter.next();
            List<PMMLOutputField> fields = child.getOutputFields();
            if (fields != null && !fields.isEmpty()) {
                Iterator<PMMLOutputField> fieldIter = fields.iterator();
                while (fieldIter.hasNext() && output == null) {
                    PMMLOutputField fld = fieldIter.next();
                    if (!fieldName.equals(fld.getName())) continue;
                    output = fld;
                }
            }
            if (!(child instanceof Miningmodel) || output != null) continue;
            output = this.getChildOutputField(child, fieldName);
        }
        return output;
    }

    public String getTargetField() {
        return this.getMiningFields().stream().filter(mf -> mf.getFieldUsageType() == FIELDUSAGETYPE.TARGET || mf.getFieldUsageType() == FIELDUSAGETYPE.PREDICTED).map(mf -> helper.compactAsJavaId(mf.getName(), true)).findFirst().orElse(null);
    }

    @Override
    public PMMLOutputField findOutputField(String fieldName) {
        return this.getChildOutputField(this, fieldName);
    }

    @Override
    public List<PMMLMiningField> getMiningFields() {
        List<PMMLMiningField> fields = super.getMiningFields();
        for (PMMLMiningField field : fields) {
            String type = field.getType();
            if (type != null && !type.trim().isEmpty()) continue;
            fields.remove(field);
        }
        if (this.segmentation != null) {
            this.segmentation.getMiningSegments().stream().flatMap(ms -> ms.getModel().getMiningFields().stream()).filter(fld -> !fields.contains(fld)).forEach(fields::add);
        }
        return fields;
    }

    @Override
    public String getMiningPojoClassName() {
        return helper.compactAsJavaId(this.getModelId().concat("MiningModelData"), true);
    }

    @Override
    public String getOutputPojoClassName() {
        return helper.compactAsJavaId(this.getModelId().concat("MiningModelOutput"), true);
    }

    @Override
    public String getRuleUnitClassName() {
        return helper.compactAsJavaId(this.getModelId().concat("MiningModelRuleUnit"), true);
    }

    @Override
    public MiningSchema getMiningSchema() {
        for (Serializable serializable : ((MiningModel)this.rawModel).getExtensionsAndMiningSchemasAndOutputs()) {
            if (!(serializable instanceof MiningSchema)) continue;
            return (MiningSchema)serializable;
        }
        return null;
    }

    @Override
    public Output getOutput() {
        for (Serializable serializable : ((MiningModel)this.rawModel).getExtensionsAndMiningSchemasAndOutputs()) {
            if (!(serializable instanceof Output)) continue;
            return (Output)serializable;
        }
        return null;
    }

    @Override
    protected void addMiningTemplateToRegistry(TemplateRegistry registry) {
        InputStream inputStream = Scorecard.class.getResourceAsStream(MINING_POJO_TEMPLATE);
        if (inputStream != null) {
            CompiledTemplate ct = TemplateCompiler.compileTemplate((InputStream)inputStream);
            registry.addNamedTemplate(this.getMiningPojoTemplateName(), ct);
        }
    }

    @Override
    protected void addOutputTemplateToRegistry(TemplateRegistry registry) {
        CompiledTemplate ct;
        InputStream inputStream = Scorecard.class.getResourceAsStream(OUTPUT_POJO_TEMPLATE);
        if (inputStream != null && (ct = TemplateCompiler.compileTemplate((InputStream)inputStream)) != null) {
            registry.addNamedTemplate(this.getOutputPojoTemplateName(), ct);
        }
    }

    @Override
    protected void addRuleUnitTemplateToRegistry(TemplateRegistry registry) {
        CompiledTemplate ct;
        InputStream inputStream = Scorecard.class.getResourceAsStream(RULE_UNIT_TEMPLATE);
        if (inputStream != null && (ct = TemplateCompiler.compileTemplate((InputStream)inputStream)) != null) {
            registry.addNamedTemplate(this.getRuleUnitTemplateName(), ct);
        }
    }

    public MININGFUNCTION getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(MININGFUNCTION functionName) {
        this.functionName = functionName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public boolean isScoreable() {
        return this.scoreable;
    }

    public void setScoreable(boolean scoreable) {
        this.scoreable = scoreable;
    }

    public MiningSegmentation getSegmentation() {
        return this.segmentation;
    }

    public String generateRules() {
        StringBuilder bldr = new StringBuilder();
        if (this.scoreable && this.segmentation != null) {
            bldr.append(this.segmentation.generateSegmentationRules());
        }
        return bldr.toString();
    }
}

