/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;

public class SimulationUtils {
    public static final double HUNDRED = 100.0;
    public static final NumberFormat formatter = new DecimalFormat("#0.00");
    public static HashMap<String, String> timeUnitMapping = new HashMap();

    public static int asInt(Object value) {
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value.toString());
    }

    public static double asDouble(Object value) {
        if (value == null) {
            return -1.0;
        }
        return Double.parseDouble(value.toString());
    }

    public static long asLong(Object value) {
        if (value == null) {
            return -1L;
        }
        return Long.parseLong(value.toString());
    }

    public static TimeUnit getTimeUnit(Map<String, Object> element) {
        String timeUnitStr = timeUnitMapping.get((String)element.get("timeunit"));
        if (timeUnitStr != null) {
            try {
                TimeUnit durationTimeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
                return durationTimeUnit;
            }
            catch (Exception e) {
                return TimeUnit.MILLISECONDS;
            }
        }
        return TimeUnit.MILLISECONDS;
    }

    public static String formatDuration(Double timeInMiliseconds) {
        return SimulationUtils.formatDuration(timeInMiliseconds.longValue());
    }

    public static String formatDuration(long timeInMiliseconds) {
        return DurationFormatUtils.formatDurationWords((long)timeInMiliseconds, (boolean)true, (boolean)true);
    }

    public static String formatDouble(double value) {
        return formatter.format(value);
    }

    public static <T> T getProperty(String property, Map<String, ? extends Object> settings, Class<T> classOfProperty, T defaultValue) {
        if (settings != null && settings.containsKey(property)) {
            return (T)settings.get(property);
        }
        return defaultValue;
    }

    static {
        timeUnitMapping.put("ms", "milliseconds");
        timeUnitMapping.put("min", "minutes");
        timeUnitMapping.put("s", "seconds");
        timeUnitMapping.put("hour", "hours");
        timeUnitMapping.put("day", "days");
        timeUnitMapping.put("year", "years");
    }
}

