/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.drools.compiler.kproject.KieModuleException;
import org.drools.compiler.kproject.models.ChannelModelImpl;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.xml.support.converters.AbstractXStreamConverter;
import org.kie.api.builder.model.ChannelModel;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;

public class KSessionConverter
extends AbstractXStreamConverter {
    public KSessionConverter() {
        super(KieSessionModelImpl.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        KieSessionModelImpl kSession = (KieSessionModelImpl)value;
        writer.addAttribute("name", kSession.getName());
        writer.addAttribute("type", kSession.getType().toString().toLowerCase());
        writer.addAttribute("default", Boolean.toString(kSession.isDefault()));
        writer.addAttribute("directFiring", Boolean.toString(kSession.isDirectFiring()));
        writer.addAttribute("threadSafe", Boolean.toString(kSession.isThreadSafe()));
        writer.addAttribute("accumulateNullPropagation", Boolean.toString(kSession.isAccumulateNullPropagation()));
        if (kSession.getClockType() != null) {
            writer.addAttribute("clockType", kSession.getClockType().getClockType());
        }
        if (kSession.getBeliefSystem() != null) {
            writer.addAttribute("beliefSystem", kSession.getBeliefSystem().getBeliefSystemType().toLowerCase());
        }
        if (kSession.getScope() != null) {
            writer.addAttribute("scope", kSession.getScope());
        }
        if (kSession.getConsoleLogger() != null) {
            writer.startNode("consoleLogger");
            if (kSession.getConsoleLogger().length() > 0) {
                writer.addAttribute("name", kSession.getConsoleLogger());
            }
            writer.endNode();
        }
        if (kSession.getFileLogger() != null) {
            writer.startNode("fileLogger");
            writer.addAttribute("file", kSession.getFileLogger().getFile());
            writer.addAttribute("threaded", "" + kSession.getFileLogger().isThreaded());
            writer.addAttribute("interval", "" + kSession.getFileLogger().getInterval());
            writer.endNode();
        }
        this.writeObjectList(writer, context, "workItemHandlers", "workItemHandler", kSession.getWorkItemHandlerModels());
        this.writeObjectList(writer, context, "channels", "channel", kSession.getChannelModels());
        this.writeMap(writer, context, "calendars", "calendar", "name", "type", kSession.getCalendars());
        if (!kSession.getListenerModels().isEmpty()) {
            writer.startNode("listeners");
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.AGENDA_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.PROCESS_EVENT_LISTENER)) {
                this.writeObject(writer, context, listener.getKind().toString(), listener);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String scope;
        String beliefSystem;
        final KieSessionModelImpl kSession = new KieSessionModelImpl();
        String kSessionName = reader.getAttribute("name");
        if (kSessionName.isEmpty()) {
            throw new KieModuleException("ksession name is empty in kmodule.xml");
        }
        kSession.setNameForUnmarshalling(kSessionName);
        kSession.setDefault("true".equals(reader.getAttribute("default")));
        kSession.setDirectFiring("true".equals(reader.getAttribute("directFiring")));
        kSession.setThreadSafe("true".equals(reader.getAttribute("threadSafe")));
        kSession.setAccumulateNullPropagation("true".equals(reader.getAttribute("accumulateNullPropagation")));
        String kSessionType = reader.getAttribute("type");
        kSession.setType(kSessionType != null ? KieSessionModel.KieSessionType.valueOf((String)kSessionType.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
        String clockType = reader.getAttribute("clockType");
        if (clockType != null) {
            kSession.setClockType(ClockTypeOption.get((String)clockType));
        }
        if ((beliefSystem = reader.getAttribute("beliefSystem")) != null) {
            kSession.setBeliefSystem(BeliefSystemTypeOption.get((String)beliefSystem));
        }
        if ((scope = reader.getAttribute("scope")) != null) {
            kSession.setScope(scope);
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            @Override
            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("listeners".equals(name)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String nodeName = reader.getNodeName();
                        ListenerModelImpl listener = KSessionConverter.this.readObject(reader, context, ListenerModelImpl.class);
                        listener.setKSession(kSession);
                        listener.setKind(ListenerModel.Kind.fromString((String)nodeName));
                        kSession.addListenerModel((ListenerModel)listener);
                        reader.moveUp();
                    }
                } else if ("workItemHandlers".equals(name)) {
                    List<WorkItemHandlerModelImpl> wihs = KSessionConverter.this.readObjectList(reader, context, WorkItemHandlerModelImpl.class);
                    for (WorkItemHandlerModelImpl wih : wihs) {
                        wih.setKSession(kSession);
                        kSession.addWorkItemHandelerModel((WorkItemHandlerModel)wih);
                    }
                } else if ("calendars".equals(name)) {
                    kSession.setCalendars(KSessionConverter.this.readMap(reader, context, "name", "type"));
                } else if ("channels".equals(name)) {
                    List<ChannelModelImpl> channels = KSessionConverter.this.readObjectList(reader, context, ChannelModelImpl.class);
                    for (ChannelModelImpl channel : channels) {
                        channel.setKSession(kSession);
                        kSession.addChannelModel((ChannelModel)channel);
                    }
                } else if ("consoleLogger".equals(name)) {
                    String consoleLogger = reader.getAttribute("name");
                    kSession.setConsoleLogger(consoleLogger == null ? "" : consoleLogger);
                } else if ("fileLogger".equals(name)) {
                    FileLoggerModelImpl fileLoggerModel = new FileLoggerModelImpl(reader.getAttribute("file"));
                    try {
                        fileLoggerModel.setInterval(Integer.parseInt(reader.getAttribute("interval")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        fileLoggerModel.setThreaded(Boolean.parseBoolean(reader.getAttribute("threaded")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    kSession.setFileLogger((FileLoggerModel)fileLoggerModel);
                }
            }
        });
        return kSession;
    }
}

