/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Actions;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Columns;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.Conditions;
import org.drools.verifier.core.index.model.DateEffectiveRuleAttribute;
import org.drools.verifier.core.index.model.DateExpiresRuleAttribute;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.model.RuleAttribute;
import org.drools.verifier.core.index.model.Rules;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.Logger;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;

public abstract class CellUpdateManagerBase {
    protected final Column column;
    protected final Actions actions;
    protected final Conditions conditions;
    protected final GuidedDecisionTable52 model;
    protected final Coordinate coordinate;
    protected final Map<String, RuleAttribute> ruleAttributes;
    private final Rule rule;

    public CellUpdateManagerBase(Index index, GuidedDecisionTable52 model, Coordinate coordinate) {
        this.model = model;
        this.coordinate = coordinate;
        Logger.add("Updating: " + coordinate.toString());
        this.column = (Column)((Columns.ColumnSelect)index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(coordinate.getCol()))).select()).first();
        this.rule = (Rule)((Rules.RulesSelect)index.getRules().where((Matcher)Rule.index().is((Comparable)Integer.valueOf(coordinate.getRow()))).select()).first();
        this.ruleAttributes = new HashMap<String, RuleAttribute>(this.rule.getRuleAttributes());
        this.actions = this.rule.getActions();
        this.conditions = this.rule.getConditions();
    }

    public boolean update() {
        boolean isAttribute = false;
        for (Map.Entry<String, RuleAttribute> entry : this.ruleAttributes.entrySet()) {
            if (this.coordinate.getCol() != entry.getValue().getIndex()) continue;
            if (this.updateRelevantAttribute(entry.getKey())) {
                return true;
            }
            isAttribute = true;
            break;
        }
        if (isAttribute) {
            return false;
        }
        if (!this.updateCondition()) {
            return this.updateAction();
        }
        return true;
    }

    private boolean updateRelevantAttribute(String attributeName) {
        if (DateEffectiveRuleAttribute.NAME.equals(attributeName)) {
            DTCellValue52 cellValue = this.getCellValue();
            this.rule.addRuleAttribute((RuleAttribute)new DateEffectiveRuleAttribute(this.coordinate.getCol(), cellValue.getDateValue()));
            return true;
        }
        if (DateExpiresRuleAttribute.NAME.equals(attributeName)) {
            DTCellValue52 cellValue = this.getCellValue();
            this.rule.addRuleAttribute((RuleAttribute)new DateExpiresRuleAttribute(this.coordinate.getCol(), cellValue.getDateValue()));
            return true;
        }
        return false;
    }

    private DTCellValue52 getCellValue() {
        DTCellValue52 cell = (DTCellValue52)((List)this.model.getData().get(this.coordinate.getRow())).get(this.coordinate.getCol());
        BaseColumn baseColumn = (BaseColumn)this.model.getExpandedColumns().get(this.coordinate.getCol());
        return Utils.getRealCellValue((DTColumnConfig52)baseColumn, cell);
    }

    private boolean updateCondition() {
        Condition condition = (Condition)((Conditions.ConditionSelector)this.conditions.where((Matcher)Condition.columnUUID().is((Comparable)this.column.getUuidKey())).select()).first();
        if (condition != null) {
            return this.updateCondition(condition);
        }
        return false;
    }

    private boolean updateAction() {
        Action action = (Action)((Actions.ActionSelect)this.actions.where((Matcher)Action.columnUUID().is((Comparable)this.column.getUuidKey())).select()).first();
        if (action != null) {
            return this.updateAction(action);
        }
        return false;
    }

    protected abstract boolean updateCondition(Condition var1);

    protected abstract boolean updateAction(Action var1);
}

